/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.testing;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomains;
import com.google.common.collect.Ranges;
import eu.stratosphere.sopremo.MathFunctions;
import eu.stratosphere.sopremo.SecondOrderFunctions;
import eu.stratosphere.sopremo.expressions.ArithmeticExpression;
import eu.stratosphere.sopremo.expressions.ComparativeExpression;
import eu.stratosphere.sopremo.expressions.ConstantExpression;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.InputSelection;
import eu.stratosphere.sopremo.function.ExpressionFunction;
import eu.stratosphere.sopremo.function.FunctionNode;
import eu.stratosphere.sopremo.function.SopremoFunction;
import eu.stratosphere.sopremo.testing.FunctionTest;
import eu.stratosphere.sopremo.type.JsonUtil;
import org.junit.Test;

public class SecondOrderFunctionsTest {
    @Test
    public void shouldFilterElements() {
        FunctionNode pointer = new FunctionNode();
        pointer.setFunction((SopremoFunction)new ExpressionFunction(1, (EvaluationExpression)new ComparativeExpression((EvaluationExpression)new InputSelection(0), ComparativeExpression.BinaryOperator.GREATER, (EvaluationExpression)new ConstantExpression((Object)5))));
        ContiguousSet input = Ranges.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(10)).asSet(DiscreteDomains.integers());
        ContiguousSet expected = Ranges.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(10)).asSet(DiscreteDomains.integers());
        FunctionTest.assertReturn(expected, SecondOrderFunctions.FILTER, input, pointer);
    }

    @Test
    public void shouldFindElements() {
        FunctionNode pointer = new FunctionNode();
        pointer.setFunction((SopremoFunction)new ExpressionFunction(1, (EvaluationExpression)new ComparativeExpression((EvaluationExpression)new InputSelection(0), ComparativeExpression.BinaryOperator.GREATER, (EvaluationExpression)new ConstantExpression((Object)5))));
        ContiguousSet input = Ranges.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(10)).asSet(DiscreteDomains.integers());
        FunctionTest.assertReturn(6, SecondOrderFunctions.FIND, input, pointer);
    }

    @Test
    public void shouldFoldElements() {
        FunctionNode pointer = new FunctionNode();
        pointer.setFunction((SopremoFunction)new ExpressionFunction(2, (EvaluationExpression)new ArithmeticExpression((EvaluationExpression)new InputSelection(0), ArithmeticExpression.ArithmeticOperator.ADDITION, (EvaluationExpression)new InputSelection(1))));
        ContiguousSet input = Ranges.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(10)).asSet(DiscreteDomains.integers());
        FunctionTest.assertReturn(55, SecondOrderFunctions.FOLD, input, 0, pointer);
    }

    @Test
    public void shouldMapElements() {
        FunctionNode pointer = new FunctionNode();
        pointer.setFunction(MathFunctions.SQR);
        FunctionTest.assertReturn(JsonUtil.createArrayNode((Object[])new Object[]{1, 4, 9}), SecondOrderFunctions.MAP, new int[]{1, 2, 3}, pointer);
    }
}

