/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.testing;

import eu.stratosphere.sopremo.CoreFunctions;
import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.function.SopremoFunction;
import eu.stratosphere.sopremo.testing.FunctionTest;
import eu.stratosphere.sopremo.type.DoubleNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IntNode;
import eu.stratosphere.sopremo.type.JsonUtil;
import eu.stratosphere.sopremo.type.MissingNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.junit.Test;

public class CoreFunctionsTest {
    protected EvaluationContext context = new EvaluationContext();

    @Test
    public void shouldCalculateMean() {
        FunctionTest.assertReturn(new BigDecimal("50"), (SopremoFunction)CoreFunctions.MEAN, 50, 25, 75);
    }

    @Test
    public void shouldCalculateMeanWithDifferentNodes() {
        ArrayList<IntNode> numbers = new ArrayList<IntNode>();
        for (int i = 1; i < 500; ++i) {
            numbers.add((IntNode)(i % 2 == 0 ? IntNode.valueOf((int)i) : DoubleNode.valueOf((double)i)));
        }
        FunctionTest.assertReturn(250.0, (SopremoFunction)CoreFunctions.MEAN, numbers.toArray());
    }

    @Test
    public void shouldCoerceDataWhenSumming() {
        FunctionTest.assertAggregate(new BigDecimal("6.5"), CoreFunctions.SUM, 1.2, 2, new BigDecimal("3.3"));
    }

    @Test
    public void shouldConcatenateStrings() {
        FunctionTest.assertAggregate("blabliblu", CoreFunctions.CONCAT, "bla", "bli", "blu");
    }

    @Test
    public void shouldCountNormalArray() {
        FunctionTest.assertReturn(3, (SopremoFunction)CoreFunctions.COUNT, new Object[]{new int[]{1, 2, 3}});
    }

    @Test
    public void shouldCountZeroForEmptyArray() {
        FunctionTest.assertReturn(0, (SopremoFunction)CoreFunctions.COUNT, new Object[]{new int[0]});
    }

    @Test
    public void shouldCreateRightCamelCaseRepresentation() {
        FunctionTest.assertReturn("This Is Just A Test !!!", CoreFunctions.CAMEL_CASE, "this iS JusT a TEST !!!");
    }

    @Test(expected=ClassCastException.class)
    public void shouldFailToSumIfNonNumbers() {
        FunctionTest.assertAggregate(null, CoreFunctions.SUM, "test");
    }

    public void shouldNotConcatenateObjects() {
        FunctionTest.assertAggregate("bla1blu2", CoreFunctions.CONCAT, "bla", 1, "blu", 2);
    }

    @Test
    public void shouldReturnCorrectSubstring() {
        FunctionTest.assertReturn("345", CoreFunctions.SUBSTRING, "0123456789", 3, 6);
    }

    @Test
    public void shouldReturnEmptyStringWhenConcatenatingEmptyArray() {
        FunctionTest.assertAggregate("", CoreFunctions.CONCAT, new Object[0]);
    }

    @Test
    public void shouldReturnMissingIfMeanNotAggregated() {
        FunctionTest.assertReturn(MissingNode.getInstance(), (SopremoFunction)CoreFunctions.MEAN, new Object[0]);
    }

    @Test
    public void shouldSortArrays() {
        IArrayNode expected = JsonUtil.createArrayNode((Object[])new Object[]{new Number[]{1, 2.4}, new Number[]{1, 3.4}, new Number[]{2, 2.4}, new Number[]{2, 2.4, 3}});
        FunctionTest.assertReturn(expected, (SopremoFunction)CoreFunctions.SORT, new Object[]{new Number[][]{{1, 3.4}, {2, 2.4}, {1, 2.4}, {2, 2.4, 3}}});
    }

    @Test
    public void shouldSortDoubles() {
        FunctionTest.assertReturn(JsonUtil.createArrayNode((Object[])new Object[]{1.2, 2.0, 3.14, 4.5}), (SopremoFunction)CoreFunctions.SORT, new Object[]{new double[]{3.14, 4.5, 1.2, 2.0}});
    }

    @Test
    public void shouldSortEmptyArray() {
        FunctionTest.assertReturn(JsonUtil.createArrayNode((Object[])new Object[0]), (SopremoFunction)CoreFunctions.SORT, new Object[]{new int[0]});
    }

    @Test
    public void shouldSortIntegers() {
        FunctionTest.assertReturn(JsonUtil.createArrayNode((Object[])new Object[]{1, 2, 3, 4}), (SopremoFunction)CoreFunctions.SORT, new Object[]{new int[]{3, 4, 1, 2}});
    }

    @Test
    public void shouldSplitCorrectly() {
        FunctionTest.assertReturn(JsonUtil.createArrayNode((Object[])new Object[]{"OpenNew", "x", "Open", "New"}), CoreFunctions.SPLIT, "OpenNew x Open New", " ");
        FunctionTest.assertReturn(JsonUtil.createArrayNode((Object[])new Object[]{"ZoomIn", "x", "Zoom", "In"}), CoreFunctions.SPLIT, "ZoomIn x Zoom In", " ");
    }

    @Test
    public void shouldSumDoubles() {
        FunctionTest.assertAggregate(6.6, CoreFunctions.SUM, 1.1, 2.2, 3.3);
    }

    @Test
    public void shouldSumEmptyArrayToZero() {
        FunctionTest.assertAggregate(0, CoreFunctions.SUM, new Object[0]);
    }

    @Test
    public void shouldSumIntegers() {
        FunctionTest.assertAggregate(6, CoreFunctions.SUM, 1, 2, 3);
    }

    @Test
    public void shouldUnionAllCompactArrays() {
        IArrayNode expectedResult = JsonUtil.createArrayNode((Object[])new Object[]{1, 2, 3, 4, 5, 6});
        FunctionTest.assertReturn(expectedResult, CoreFunctions.UNION_ALL, JsonUtil.createCompactArray((Object[])new Object[]{1, 2, 3}), JsonUtil.createCompactArray((Object[])new Object[]{4, 5}), JsonUtil.createCompactArray((Object[])new Object[]{6}));
    }

    @Test
    public void shouldUnionAllMixedArrayTypes() {
        IArrayNode expectedResult = JsonUtil.createArrayNode((Object[])new Object[]{1, 2, 3, 4, 5, 6});
        FunctionTest.assertReturn(expectedResult, CoreFunctions.UNION_ALL, JsonUtil.createArrayNode((Object[])new Object[]{1, 2, 3}), JsonUtil.createCompactArray((Object[])new Object[]{4, 5}), JsonUtil.createArrayNode((Object[])new Object[]{6}));
    }

    @Test
    public void shouldUnionAllNormalArrays() {
        IArrayNode expectedResult = JsonUtil.createArrayNode((Object[])new Object[]{1, 2, 3, 4, 5, 6});
        FunctionTest.assertReturn(expectedResult, CoreFunctions.UNION_ALL, JsonUtil.createArrayNode((Object[])new Object[]{1, 2, 3}), JsonUtil.createArrayNode((Object[])new Object[]{4, 5, 6}));
    }

    @Test
    public void shouldUnionAllStreamArrays() {
        FunctionTest.assertReturn(JsonUtil.createArrayNode((Object[])new Object[]{1, 2, 3, 4, 5, 6}), CoreFunctions.UNION_ALL, JsonUtil.createStreamArrayNode((Object[])new Object[]{1, 2, 3}), JsonUtil.createStreamArrayNode((Object[])new Object[]{4, 5}), JsonUtil.createStreamArrayNode((Object[])new Object[]{6}));
    }
}

