/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type.typed;

import eu.stratosphere.sopremo.type.typed.ASMClassBuilder;
import eu.stratosphere.sopremo.type.typed.ITypedObjectNode;
import eu.stratosphere.util.IdentitySet;
import eu.stratosphere.util.reflect.ReflectUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class TypedObjectNodeFactory {
    private static TypedObjectNodeFactory instance = null;
    private final Map<Class<? extends ITypedObjectNode>, Class<? extends ITypedObjectNode>> typesMap = new IdentityHashMap<Class<? extends ITypedObjectNode>, Class<? extends ITypedObjectNode>>();

    private TypedObjectNodeFactory() {
    }

    public <T extends ITypedObjectNode> T getTypedObjectForInterface(Class<T> myInterface) {
        Class<ITypedObjectNode> classObject = this.typesMap.get(myInterface);
        if (classObject == null) {
            try {
                classObject = this.createSuperClassForInterface(myInterface);
                this.typesMap.put(myInterface, classObject);
            }
            catch (Exception e) {
                throw new IllegalStateException("cannot load class", e);
            }
        }
        return (T)((ITypedObjectNode)ReflectUtil.newInstance(classObject));
    }

    private Set<Class<?>> collectAllInterfacesToImplement(Class<?> anInterface) {
        IdentitySet allInterfacesToImplement = new IdentitySet();
        for (Class<?> superInterface : anInterface.getInterfaces()) {
            if (!ITypedObjectNode.class.isAssignableFrom(superInterface) || superInterface == ITypedObjectNode.class) continue;
            allInterfacesToImplement.add(superInterface);
            allInterfacesToImplement.addAll(this.collectAllInterfacesToImplement(superInterface));
        }
        allInterfacesToImplement.add(anInterface);
        return allInterfacesToImplement;
    }

    private <T extends ITypedObjectNode> Class<T> createSuperClassForInterface(Class<T> myInterface) throws Exception {
        String className = myInterface.getName() + "Impl";
        ASMClassBuilder classBuilder = new ASMClassBuilder(className, myInterface);
        HashSet<String> uniqueProperties = new HashSet<String>();
        Set<Class<?>> allInterfacesInHierarchyToImplement = this.collectAllInterfacesToImplement(myInterface);
        for (Class<?> extendedInterface : allInterfacesInHierarchyToImplement) {
            PropertyDescriptor[] props;
            BeanInfo interfaceInfo = this.getBeanInfo(extendedInterface);
            for (PropertyDescriptor prop : props = interfaceInfo.getPropertyDescriptors()) {
                if (uniqueProperties.contains(prop.getName())) continue;
                uniqueProperties.add(prop.getName());
                classBuilder.addAccessorsForProperty(prop);
            }
        }
        Class<T> classObject = this.loadClass(classBuilder.dump(), className);
        return classObject;
    }

    private BeanInfo getBeanInfo(Class<?> clazz) {
        try {
            return Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("Cannot inspect class " + clazz, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ITypedObjectNode> Class<T> loadClass(byte[] b, String className) throws Exception {
        Class clazz = null;
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        Class<?> cls = Class.forName("java.lang.ClassLoader");
        Method method = cls.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        method.setAccessible(true);
        try {
            Object[] args = new Object[]{className, b, new Integer(0), new Integer(b.length)};
            clazz = (Class)method.invoke((Object)loader, args);
        }
        finally {
            method.setAccessible(false);
        }
        return clazz;
    }

    public static TypedObjectNodeFactory getInstance() {
        if (instance == null) {
            instance = new TypedObjectNodeFactory();
        }
        return instance;
    }
}

