/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type.typed;

import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.JavaToJsonMapper;
import eu.stratosphere.sopremo.type.JsonToJavaMapper;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.NullNode;
import eu.stratosphere.sopremo.type.ObjectNode;
import eu.stratosphere.sopremo.type.typed.ITypedObjectNode;
import eu.stratosphere.sopremo.type.typed.TypedObjectNodeFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public abstract class TypedObjectNode
implements ITypedObjectNode {
    protected IObjectNode backingObject = new ObjectNode();
    protected static final JavaToJsonMapper JavaToJsonMapperInstance = JavaToJsonMapper.INSTANCE;
    protected static final JsonToJavaMapper JsonToJavaMapperInstance = JsonToJavaMapper.INSTANCE;

    protected TypedObjectNode() {
    }

    public void appendAsString(Appendable appendable) throws IOException {
        this.backingObject.appendAsString(appendable);
    }

    @Override
    public void clear() {
        this.backingObject.clear();
    }

    @Override
    public TypedObjectNode clone() {
        try {
            TypedObjectNode clone = (TypedObjectNode)this.getClass().newInstance();
            clone.backingObject = this.backingObject.clone();
            return clone;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public int compareTo(IJsonNode other) {
        return this.backingObject.compareTo(other);
    }

    @Override
    public int compareToSameType(IJsonNode other) {
        return this.backingObject.compareTo(other);
    }

    @Override
    public void copyValueFrom(IJsonNode otherNode) {
        this.backingObject.copyValueFrom(otherNode);
    }

    @Override
    public final <T extends IJsonNode> T get(String fieldName) {
        return this.backingObject.get(fieldName);
    }

    public IObjectNode getBackingNode() {
        return this.backingObject;
    }

    public final <T extends IJsonNode> T getOrNull(String fieldName) {
        Object result = this.backingObject.get(fieldName);
        if (result == MissingNode.getInstance() || result == NullNode.getInstance()) {
            return null;
        }
        return result;
    }

    public Class<IObjectNode> getType() {
        return IObjectNode.class;
    }

    public final <T extends ITypedObjectNode> T getTyped(String fieldName, T object) {
        T result = this.get(fieldName);
        if (result == MissingNode.getInstance() || result == NullNode.getInstance()) {
            return null;
        }
        ((TypedObjectNode)object).setBackingNode((IObjectNode)result);
        return object;
    }

    @Override
    public Iterator<Map.Entry<String, IJsonNode>> iterator() {
        return this.backingObject.iterator();
    }

    @Override
    public IObjectNode put(String fieldName, IJsonNode value) {
        return this.backingObject.put(fieldName, value);
    }

    @Override
    public IObjectNode putAll(IObjectNode jsonNode) {
        return this.backingObject.putAll(jsonNode);
    }

    public IObjectNode putOrNull(String fieldName, IJsonNode value) {
        return this.backingObject.put(fieldName, value == null ? NullNode.getInstance() : value);
    }

    public final void putTyped(String fieldName, ITypedObjectNode value) {
        this.backingObject.put(fieldName, value == null ? NullNode.getInstance() : ((TypedObjectNode)value).getBackingNode());
    }

    @Override
    public void remove(String fieldName) {
        this.backingObject.remove(fieldName);
    }

    public void setBackingNode(IObjectNode backingNode) {
        this.backingObject = backingNode;
    }

    @Override
    public int size() {
        return this.backingObject.size();
    }

    public TypedObjectNode withBackingNode(IObjectNode backingNode) {
        this.backingObject = backingNode;
        return this;
    }

    protected final <T extends ITypedObjectNode> T createWrappingObject(Class<T> aDesiredClass) {
        return TypedObjectNodeFactory.getInstance().getTypedObjectForInterface(aDesiredClass);
    }
}

