/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type.typed;

import com.google.common.reflect.TypeToken;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.JavaToJsonMapper;
import eu.stratosphere.sopremo.type.JsonToJavaMapper;
import eu.stratosphere.sopremo.type.NullNode;
import eu.stratosphere.sopremo.type.TypeMapper;
import eu.stratosphere.sopremo.type.typed.ITypedObjectNode;
import eu.stratosphere.sopremo.type.typed.TypedObjectNode;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class ASMClassBuilder
implements Opcodes {
    private final ClassWriter classWriter = new ClassWriter(3);
    private final String className;
    private static final Class<?> BaseClass = TypedObjectNode.class;
    private static final String BaseClassName = org.objectweb.asm.Type.getInternalName(BaseClass);
    private final List<FieldInitializer> fieldInitializations = new ArrayList<FieldInitializer>();
    private static final String MapperDescriptor = org.objectweb.asm.Type.getDescriptor(TypeMapper.class);
    private static final String MapperInternalName = org.objectweb.asm.Type.getInternalName(TypeMapper.class);

    public ASMClassBuilder(String className, Class<?> ... interfaces) {
        this.className = className.replace('.', '/');
        String[] interfaceNames = new String[interfaces.length];
        for (int index = 0; index < interfaceNames.length; ++index) {
            interfaceNames[index] = org.objectweb.asm.Type.getInternalName(interfaces[index]);
        }
        this.classWriter.visit(49, 49, this.className, null, BaseClassName, interfaceNames);
    }

    public void addAccessorsForProperty(PropertyDescriptor prop) throws Exception {
        if (prop.getReadMethod() != null) {
            if (ITypedObjectNode.class.isAssignableFrom(prop.getPropertyType())) {
                this.addTypedGetterMethod(prop);
            } else if (IJsonNode.class.isAssignableFrom(prop.getPropertyType())) {
                this.addGetterMethod(prop);
            } else {
                this.addConvertingGetterMethod(prop);
            }
        }
        if (prop.getWriteMethod() != null) {
            if (ITypedObjectNode.class.isAssignableFrom(prop.getPropertyType())) {
                this.addTypedSetterMethod(prop);
            } else if (IJsonNode.class.isAssignableFrom(prop.getPropertyType())) {
                this.addSetterMethod(prop);
            } else {
                this.addConvertingSetterMethod(prop);
            }
        }
    }

    protected byte[] dump() throws Exception {
        this.addCtor();
        this.classWriter.visitEnd();
        return this.classWriter.toByteArray();
    }

    protected String getConvertedJsonCacheFieldName(String propName) {
        return propName + "JsonValue";
    }

    protected String getConvertedTypeCacheFieldName(String propName) {
        return propName + "JavaValue";
    }

    protected String getTypedObjectCacheFieldName(String propName) {
        return propName + "TypedObject";
    }

    private void addConvertingGetterMethod(PropertyDescriptor prop) throws Exception {
        boolean reusableType;
        Type jsonType = JavaToJsonMapper.INSTANCE.getDefaultMappingType(prop.getPropertyType());
        if (jsonType == null) {
            throw new IllegalArgumentException("Cannot create getter for type. " + prop.getPropertyType());
        }
        final Class rawJsonType = TypeToken.of((Type)jsonType).getRawType();
        String propName = prop.getName();
        final Class<?> propertyType = prop.getPropertyType();
        String propertyTypeDesc = org.objectweb.asm.Type.getDescriptor(propertyType);
        String javaField = this.getConvertedTypeCacheFieldName(propName);
        final String mapperField = propName + "JsonToJavaMapper";
        FieldVisitor fv = this.classWriter.visitField(18, mapperField, MapperDescriptor, null, null);
        fv.visitEnd();
        this.fieldInitializations.add(new FieldInitializer(){

            @Override
            public void initialize(MethodVisitor methodVisitor) throws Exception {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(178, BaseClassName, "JsonToJavaMapperInstance", org.objectweb.asm.Type.getDescriptor(JsonToJavaMapper.class));
                methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)rawJsonType));
                methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)propertyType));
                methodVisitor.visitMethodInsn(182, org.objectweb.asm.Type.getInternalName(JsonToJavaMapper.class), "getMapper", org.objectweb.asm.Type.getMethodDescriptor((Method)JsonToJavaMapper.class.getMethod("getMapper", Class.class, Class.class)));
                methodVisitor.visitFieldInsn(181, ASMClassBuilder.this.className, mapperField, MapperDescriptor);
            }
        });
        TypeMapper mapper = (TypeMapper)JsonToJavaMapper.INSTANCE.getMapper(rawJsonType, (Type)propertyType);
        boolean bl = reusableType = mapper.getDefaultType() != null;
        if (reusableType) {
            fv = this.classWriter.visitField(18, javaField, propertyTypeDesc, null, null);
            fv.visitEnd();
        }
        boolean hasSetterCache = prop.getWriteMethod() != null && ((TypeMapper)JavaToJsonMapper.INSTANCE.getMapper(propertyType, (Type)rawJsonType)).getDefaultType() != null;
        MethodVisitor methodVisitor = this.classWriter.visitMethod(1, prop.getReadMethod().getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)prop.getReadMethod()), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)propName);
        methodVisitor.visitMethodInsn(183, BaseClassName, "getOrNull", org.objectweb.asm.Type.getMethodDescriptor((Method)BaseClass.getMethod("getOrNull", String.class)));
        methodVisitor.visitInsn(89);
        Label returnLabel = new Label();
        methodVisitor.visitJumpInsn(198, returnLabel);
        if (hasSetterCache) {
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitInsn(95);
            methodVisitor.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName((Class)rawJsonType));
            methodVisitor.visitFieldInsn(181, this.className, this.getConvertedJsonCacheFieldName(propName), org.objectweb.asm.Type.getDescriptor((Class)rawJsonType));
        }
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.className, mapperField, MapperDescriptor);
        methodVisitor.visitInsn(95);
        if (reusableType) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.className, javaField, propertyTypeDesc);
            methodVisitor.visitInsn(89);
            Label cacheLabel = new Label();
            methodVisitor.visitJumpInsn(199, cacheLabel);
            methodVisitor.visitInsn(87);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitTypeInsn(187, org.objectweb.asm.Type.getInternalName(mapper.getDefaultType()));
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, org.objectweb.asm.Type.getInternalName(mapper.getDefaultType()), "<init>", "()V");
            methodVisitor.visitInsn(90);
            methodVisitor.visitFieldInsn(181, this.className, javaField, propertyTypeDesc);
            methodVisitor.visitLabel(cacheLabel);
        } else {
            methodVisitor.visitInsn(1);
        }
        methodVisitor.visitMethodInsn(182, MapperInternalName, "mapTo", org.objectweb.asm.Type.getMethodDescriptor((Method)TypeMapper.class.getMethod("mapTo", Object.class, Object.class)));
        methodVisitor.visitLabel(returnLabel);
        methodVisitor.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(propertyType));
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void addConvertingSetterMethod(PropertyDescriptor prop) throws Exception {
        Type jsonType = JavaToJsonMapper.INSTANCE.getDefaultMappingType(prop.getPropertyType());
        if (jsonType == null) {
            throw new IllegalArgumentException("Cannot create setter for type. " + prop.getPropertyType());
        }
        final Class rawJsonType = TypeToken.of((Type)jsonType).getRawType();
        String propName = prop.getName();
        final Class<?> propertyType = prop.getPropertyType();
        String propertyTypeDesc = org.objectweb.asm.Type.getDescriptor(propertyType);
        final String mapperField = propName + "JavaToJsonMapper";
        FieldVisitor fv = this.classWriter.visitField(18, mapperField, MapperDescriptor, null, null);
        fv.visitEnd();
        this.fieldInitializations.add(new FieldInitializer(){

            @Override
            public void initialize(MethodVisitor methodVisitor) throws Exception {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(178, BaseClassName, "JavaToJsonMapperInstance", org.objectweb.asm.Type.getDescriptor(JavaToJsonMapper.class));
                methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)propertyType));
                methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)rawJsonType));
                methodVisitor.visitMethodInsn(182, org.objectweb.asm.Type.getInternalName(JavaToJsonMapper.class), "getMapper", org.objectweb.asm.Type.getMethodDescriptor((Method)JavaToJsonMapper.class.getMethod("getMapper", Class.class, Class.class)));
                methodVisitor.visitFieldInsn(181, ASMClassBuilder.this.className, mapperField, MapperDescriptor);
            }
        });
        TypeMapper mapper = (TypeMapper)JavaToJsonMapper.INSTANCE.getMapper(propertyType, (Type)rawJsonType);
        boolean reusableType = mapper.getDefaultType() != null;
        String jsonValue = this.getConvertedJsonCacheFieldName(propName);
        String jsonDesc = org.objectweb.asm.Type.getDescriptor((Class)rawJsonType);
        if (reusableType) {
            fv = this.classWriter.visitField(18, jsonValue, jsonDesc, null, null);
            fv.visitEnd();
        }
        MethodVisitor methodVisitor = this.classWriter.visitMethod(1, prop.getWriteMethod().getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)prop.getWriteMethod()), null, null);
        methodVisitor.visitCode();
        boolean hasGetterCache = prop.getReadMethod() != null && ((TypeMapper)JsonToJavaMapper.INSTANCE.getMapper(rawJsonType, (Type)propertyType)).getDefaultType() != null;
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)propName);
        methodVisitor.visitVarInsn(25, 1);
        Label nonNullLabel = new Label();
        Label returnLabel = new Label();
        methodVisitor.visitJumpInsn(199, nonNullLabel);
        methodVisitor.visitMethodInsn(184, org.objectweb.asm.Type.getInternalName(NullNode.class), "getInstance", org.objectweb.asm.Type.getMethodDescriptor((Method)NullNode.class.getMethod("getInstance", new Class[0])));
        methodVisitor.visitJumpInsn(167, returnLabel);
        methodVisitor.visitLabel(nonNullLabel);
        if (hasGetterCache) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitFieldInsn(181, this.className, this.getConvertedTypeCacheFieldName(propName), propertyTypeDesc);
        }
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.className, mapperField, MapperDescriptor);
        methodVisitor.visitVarInsn(25, 1);
        if (reusableType) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.className, jsonValue, jsonDesc);
            Label cacheLabel = new Label();
            methodVisitor.visitInsn(89);
            methodVisitor.visitJumpInsn(199, cacheLabel);
            methodVisitor.visitInsn(87);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitTypeInsn(187, org.objectweb.asm.Type.getInternalName(mapper.getDefaultType()));
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, org.objectweb.asm.Type.getInternalName(mapper.getDefaultType()), "<init>", "()V");
            methodVisitor.visitInsn(90);
            methodVisitor.visitFieldInsn(181, this.className, jsonValue, jsonDesc);
            methodVisitor.visitLabel(cacheLabel);
        } else {
            methodVisitor.visitInsn(1);
        }
        methodVisitor.visitMethodInsn(182, MapperInternalName, "mapTo", org.objectweb.asm.Type.getMethodDescriptor((Method)TypeMapper.class.getMethod("mapTo", Object.class, Object.class)));
        methodVisitor.visitLabel(returnLabel);
        methodVisitor.visitMethodInsn(183, BaseClassName, "put", org.objectweb.asm.Type.getMethodDescriptor((Method)BaseClass.getMethod("put", String.class, IJsonNode.class)));
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void addCtor() throws Exception {
        MethodVisitor methodVisitor = this.classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, BaseClassName, "<init>", "()V");
        for (FieldInitializer initialization : this.fieldInitializations) {
            initialization.initialize(methodVisitor);
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void addGetterMethod(PropertyDescriptor prop) throws Exception {
        String propertyTypeName = org.objectweb.asm.Type.getInternalName(prop.getPropertyType());
        String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)prop.getReadMethod());
        String name = prop.getReadMethod().getName();
        MethodVisitor methodVisitor = this.classWriter.visitMethod(4097, name, methodDescriptor, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)prop.getName());
        String getSignature = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(IJsonNode.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(String.class)});
        methodVisitor.visitMethodInsn(183, this.className, "getOrNull", getSignature);
        methodVisitor.visitTypeInsn(192, propertyTypeName);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void addSetterMethod(PropertyDescriptor prop) throws Exception {
        MethodVisitor methodVisitor = this.classWriter.visitMethod(1, prop.getWriteMethod().getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)prop.getWriteMethod()), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)prop.getName());
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(183, this.className, "putOrNull", org.objectweb.asm.Type.getMethodDescriptor((Method)TypedObjectNode.class.getMethod("putOrNull", String.class, IJsonNode.class)));
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void addTypedGetterMethod(PropertyDescriptor prop) throws Exception {
        String propName = prop.getName();
        Class<?> propertyType = prop.getPropertyType();
        String propertyTypeName = org.objectweb.asm.Type.getDescriptor(propertyType);
        String typeField = this.getTypedObjectCacheFieldName(propName);
        FieldVisitor fv = this.classWriter.visitField(2, typeField, propertyTypeName, null, null);
        fv.visitEnd();
        MethodVisitor methodVisitor = this.classWriter.visitMethod(1, prop.getReadMethod().getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)prop.getReadMethod()), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)prop.getName());
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.className, typeField, propertyTypeName);
        Label getTypedLabel = new Label();
        methodVisitor.visitInsn(89);
        methodVisitor.visitJumpInsn(199, getTypedLabel);
        methodVisitor.visitInsn(87);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType(propertyType));
        methodVisitor.visitMethodInsn(183, BaseClassName, "createWrappingObject", org.objectweb.asm.Type.getMethodDescriptor((Method)BaseClass.getDeclaredMethod("createWrappingObject", Class.class)));
        methodVisitor.visitInsn(90);
        methodVisitor.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(propertyType));
        methodVisitor.visitFieldInsn(181, this.className, typeField, propertyTypeName);
        methodVisitor.visitLabel(getTypedLabel);
        methodVisitor.visitMethodInsn(183, BaseClassName, "getTyped", org.objectweb.asm.Type.getMethodDescriptor((Method)TypedObjectNode.class.getMethod("getTyped", String.class, ITypedObjectNode.class)));
        methodVisitor.visitTypeInsn(192, propertyTypeName);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void addTypedSetterMethod(PropertyDescriptor prop) throws Exception {
        MethodVisitor methodVisitor = this.classWriter.visitMethod(1, prop.getWriteMethod().getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)prop.getWriteMethod()), null, null);
        methodVisitor.visitCode();
        if (prop.getReadMethod() != null) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitFieldInsn(181, this.className, this.getTypedObjectCacheFieldName(prop.getName()), org.objectweb.asm.Type.getDescriptor(prop.getPropertyType()));
        }
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)prop.getName());
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(183, this.className, "putTyped", org.objectweb.asm.Type.getMethodDescriptor((Method)TypedObjectNode.class.getMethod("putTyped", String.class, ITypedObjectNode.class)));
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static interface FieldInitializer {
        public void initialize(MethodVisitor var1) throws Exception;
    }
}

