/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import eu.stratosphere.sopremo.cache.NodeCache;
import eu.stratosphere.sopremo.type.AbstractNumericNode;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.BigIntegerNode;
import eu.stratosphere.sopremo.type.BooleanNode;
import eu.stratosphere.sopremo.type.CoercionException;
import eu.stratosphere.sopremo.type.DecimalNode;
import eu.stratosphere.sopremo.type.DoubleNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.INumericNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.IntNode;
import eu.stratosphere.sopremo.type.LongNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.NullNode;
import eu.stratosphere.sopremo.type.NumberCoercer;
import eu.stratosphere.sopremo.type.TextNode;
import eu.stratosphere.sopremo.type.TypeMapper;
import eu.stratosphere.util.Reference;
import eu.stratosphere.util.reflect.ReflectUtil;
import eu.stratosphere.util.reflect.TypeHierarchyBrowser;
import eu.stratosphere.util.reflect.Visitor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javolution.text.TypeFormat;

public class TypeCoercer {
    private final Map<Class<? extends IJsonNode>, Map<Class<? extends IJsonNode>, TypeMapper<?, ?>>> coercers = new IdentityHashMap();
    public static final List<Class<? extends INumericNode>> NUMERIC_TYPES = Arrays.asList(IntNode.class, DoubleNode.class, LongNode.class, DecimalNode.class, BigIntegerNode.class);
    private static final TypeMapper<IJsonNode, IJsonNode> NULL_COERCER = new TypeMapper<IJsonNode, IJsonNode>(null){

        @Override
        public IJsonNode mapTo(IJsonNode node, IJsonNode target) {
            return null;
        }
    };
    public static final TypeCoercer INSTANCE = new TypeCoercer();

    public TypeCoercer() {
        this.addCoercers(MissingNode.class, new IdentityHashMap());
        this.addCoercers(BooleanNode.class, this.getToBooleanCoercers());
        this.addCoercers(TextNode.class, this.getToStringCoercers());
        this.addCoercers(IArrayNode.class, this.getToArrayCoercers());
        this.addCoercers(IObjectNode.class, new IdentityHashMap());
        this.addNumericCoercers(this.coercers);
        this.addCoercers(IJsonNode.class, new IdentityHashMap());
        this.addSelfCoercers();
    }

    public <To extends IJsonNode> void addCoercers(Class<To> targetClass, Map<?, TypeMapper<?, To>> coercers) {
        this.coercers.put(targetClass, coercers);
    }

    public <From extends IJsonNode, To extends IJsonNode> To coerce(From node, NodeCache nodeCache, Class<To> targetType) {
        To result = this.coerce(node, nodeCache, targetType, null);
        if (result == null) {
            throw new CoercionException(String.format("Cannot coerce %s to %s", node, targetType));
        }
        return result;
    }

    public <From extends IJsonNode, To extends IJsonNode> To coerce(From node, NodeCache nodeCache, Class<To> targetClass, To defaultValue) {
        Class<?> defaultType;
        TypeMapper<Object, Object> fromCoercer;
        Map<Class<IJsonNode>, TypeMapper<?, ?>> toCoercer = this.coercers.get(targetClass);
        if (toCoercer == null) {
            Map<Class<IJsonNode>, TypeMapper<To, To>> superclassCoercers = this.findSuperclassCoercers(targetClass);
            toCoercer = superclassCoercers == null ? new IdentityHashMap() : new IdentityHashMap<Class<IJsonNode>, TypeMapper<To, To>>(superclassCoercers);
            this.coercers.put(targetClass, toCoercer);
        }
        if ((fromCoercer = toCoercer.get(node.getClass())) == null) {
            fromCoercer = this.findJoiningCoercer(node, toCoercer);
            if (fromCoercer == null) {
                fromCoercer = NULL_COERCER;
            }
            toCoercer.put(node.getClass(), fromCoercer);
        }
        IJsonNode result = (defaultType = fromCoercer.getDefaultType()) != null ? (IJsonNode)nodeCache.getNode(defaultType) : null;
        if ((result = (IJsonNode)fromCoercer.mapTo(node, result)) == null) {
            return defaultValue;
        }
        return (To)result;
    }

    public <From extends IJsonNode, To extends IJsonNode> To coerce(From node, NodeCache nodeCache, To defaultValue) {
        return (To)this.coerce(node, nodeCache, defaultValue.getClass(), defaultValue);
    }

    public <From extends IJsonNode, To extends IJsonNode> void setCoercer(Class<From> from, Class<To> to, TypeMapper<From, To> coercer) {
        Map<Class<IJsonNode>, TypeMapper<?, ?>> toCoercers = this.coercers.get(to);
        if (toCoercers == null) {
            toCoercers = new IdentityHashMap();
            this.coercers.put(to, toCoercers);
        }
        toCoercers.put(from, coercer);
    }

    protected <To, From> TypeMapper<From, To> findJoiningCoercer(From node, final Map<Class<? extends IJsonNode>, TypeMapper<?, ?>> toCoercer) {
        final Reference fromCoercer = new Reference();
        TypeHierarchyBrowser.INSTANCE.visit(node.getClass(), TypeHierarchyBrowser.Mode.CLASS_FIRST, new Visitor<Class<?>>(){

            public boolean visited(Class<?> superClass, int distance) {
                TypeMapper coercer = (TypeMapper)toCoercer.get(superClass);
                if (coercer == null) {
                    return true;
                }
                fromCoercer.setValue((Object)coercer);
                return false;
            }
        });
        return (TypeMapper)fromCoercer.getValue();
    }

    protected <To, From> Map<Class<? extends IJsonNode>, TypeMapper<?, ?>> findSuperclassCoercers(Class<?> toClass) {
        final Reference toCoercers = new Reference();
        TypeHierarchyBrowser.INSTANCE.visit(toClass, TypeHierarchyBrowser.Mode.CLASS_FIRST, new Visitor<Class<?>>(){

            public boolean visited(Class<?> superClass, int distance) {
                Map froms = (Map)TypeCoercer.this.coercers.get(superClass);
                if (froms == null) {
                    return true;
                }
                toCoercers.setValue((Object)froms);
                return false;
            }
        });
        return (Map)toCoercers.getValue();
    }

    private void addNumericCoercers(Map<Class<? extends IJsonNode>, Map<Class<? extends IJsonNode>, TypeMapper<?, ?>>> coercers) {
        coercers.put(AbstractNumericNode.class, new IdentityHashMap());
        for (Class<? extends INumericNode> numericType : NUMERIC_TYPES) {
            IdentityHashMap<Class<AbstractNumericNode>, TypeMapper<? extends INumericNode, ? extends INumericNode>> typeCoercers = new IdentityHashMap<Class<AbstractNumericNode>, TypeMapper<? extends INumericNode, ? extends INumericNode>>();
            coercers.put(numericType, typeCoercers);
            typeCoercers.put(AbstractNumericNode.class, NumberCoercer.INSTANCE.getCoercers().get(numericType));
        }
        coercers.get(AbstractNumericNode.class).put(BooleanNode.class, new TypeMapper<BooleanNode, IntNode>(IntNode.class){

            @Override
            public IntNode mapTo(BooleanNode from, IntNode target) {
                target.setValue(from == BooleanNode.TRUE ? 1 : 0);
                return target;
            }
        });
        coercers.get(IntNode.class).put(BooleanNode.class, new TypeMapper<BooleanNode, IntNode>(IntNode.class){

            @Override
            public IntNode mapTo(BooleanNode from, IntNode target) {
                target.setValue(from == BooleanNode.TRUE ? 1 : 0);
                return target;
            }
        });
        coercers.get(DoubleNode.class).put(BooleanNode.class, new TypeMapper<BooleanNode, DoubleNode>(DoubleNode.class){

            @Override
            public DoubleNode mapTo(BooleanNode from, DoubleNode target) {
                target.setValue(from == BooleanNode.TRUE ? 1.0 : 0.0);
                return target;
            }
        });
        coercers.get(LongNode.class).put(BooleanNode.class, new TypeMapper<BooleanNode, LongNode>(LongNode.class){

            @Override
            public LongNode mapTo(BooleanNode from, LongNode target) {
                target.setValue(from == BooleanNode.TRUE ? 1L : 0L);
                return target;
            }
        });
        coercers.get(DecimalNode.class).put(BooleanNode.class, new TypeMapper<BooleanNode, DecimalNode>(DecimalNode.class){

            @Override
            public DecimalNode mapTo(BooleanNode from, DecimalNode target) {
                target.setValue(from == BooleanNode.TRUE ? BigDecimal.ONE : BigDecimal.ZERO);
                return target;
            }
        });
        coercers.get(BigIntegerNode.class).put(BooleanNode.class, new TypeMapper<BooleanNode, BigIntegerNode>(BigIntegerNode.class){

            @Override
            public BigIntegerNode mapTo(BooleanNode from, BigIntegerNode target) {
                target.setValue(from == BooleanNode.TRUE ? BigInteger.ONE : BigInteger.ZERO);
                return target;
            }
        });
        coercers.get(AbstractNumericNode.class).put(BooleanNode.class, coercers.get(IntNode.class).get(BooleanNode.class));
        coercers.get(IntNode.class).put(TextNode.class, new TypeMapper<TextNode, IntNode>(IntNode.class){

            @Override
            public IntNode mapTo(TextNode from, IntNode target) {
                try {
                    target.setValue(TypeFormat.parseInt((CharSequence)from));
                    return target;
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        coercers.get(DoubleNode.class).put(TextNode.class, new TypeMapper<TextNode, DoubleNode>(DoubleNode.class){

            @Override
            public DoubleNode mapTo(TextNode from, DoubleNode target) {
                try {
                    target.setValue(TypeFormat.parseDouble((CharSequence)from));
                    return target;
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        coercers.get(LongNode.class).put(TextNode.class, new TypeMapper<TextNode, LongNode>(LongNode.class){

            @Override
            public LongNode mapTo(TextNode from, LongNode target) {
                try {
                    target.setValue(TypeFormat.parseLong((CharSequence)from));
                    return target;
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        coercers.get(DecimalNode.class).put(TextNode.class, new TypeMapper<TextNode, DecimalNode>(DecimalNode.class){

            @Override
            public DecimalNode mapTo(TextNode from, DecimalNode target) {
                try {
                    target.setValue(new BigDecimal(from.toString()));
                    return target;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        });
        coercers.get(BigIntegerNode.class).put(TextNode.class, new TypeMapper<TextNode, BigIntegerNode>(BigIntegerNode.class){

            @Override
            public BigIntegerNode mapTo(TextNode from, BigIntegerNode target) {
                try {
                    target.setValue(new BigInteger(from.toString()));
                    return target;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        });
        coercers.get(AbstractNumericNode.class).put(TextNode.class, coercers.get(DecimalNode.class).get(TextNode.class));
    }

    private void addSelfCoercers() {
        for (Map.Entry<Class<IJsonNode>, Map<Class<IJsonNode>, TypeMapper<?, ?>>> toCoercers : this.coercers.entrySet()) {
            Class<? extends IJsonNode> targetClass = toCoercers.getKey();
            Map<Class<IJsonNode>, TypeMapper<?, ?>> coercers = toCoercers.getValue();
            if (coercers.containsKey(targetClass)) continue;
            if (targetClass.isInterface()) {
                coercers.put(targetClass, new CopyCoercer());
                continue;
            }
            coercers.put(targetClass, new SelfCoercer(targetClass));
        }
    }

    private Map<Class<? extends IJsonNode>, TypeMapper<?, IArrayNode>> getToArrayCoercers() {
        IdentityHashMap toArrayCoercers = new IdentityHashMap();
        toArrayCoercers.put(IJsonNode.class, new TypeMapper<IJsonNode, IArrayNode>(ArrayNode.class){

            @Override
            public IArrayNode<IJsonNode> mapTo(IJsonNode from, IArrayNode target) {
                target.clear();
                target.add(from);
                return target;
            }
        });
        toArrayCoercers.put(IArrayNode.class, new TypeMapper<IArrayNode, IArrayNode>(ArrayNode.class){

            @Override
            public IArrayNode<IJsonNode> mapTo(IArrayNode from, IArrayNode target) {
                target.clear();
                target.addAll(from);
                return target;
            }
        });
        toArrayCoercers.put(IObjectNode.class, new TypeMapper<IObjectNode, IArrayNode>(ArrayNode.class){

            @Override
            public IArrayNode<IJsonNode> mapTo(IObjectNode from, IArrayNode target) {
                target.clear();
                for (Map.Entry<String, IJsonNode> entry : from) {
                    target.add(entry.getValue());
                }
                return target;
            }
        });
        return toArrayCoercers;
    }

    private Map<Class<? extends IJsonNode>, TypeMapper<?, BooleanNode>> getToBooleanCoercers() {
        IdentityHashMap toBooleanCoercers = new IdentityHashMap();
        toBooleanCoercers.put(BooleanNode.class, new TypeMapper<BooleanNode, BooleanNode>(BooleanNode.class){

            @Override
            public BooleanNode mapTo(BooleanNode from, BooleanNode target) {
                return from;
            }
        });
        toBooleanCoercers.put(INumericNode.class, new TypeMapper<INumericNode, BooleanNode>(BooleanNode.class){

            @Override
            public BooleanNode mapTo(INumericNode from, BooleanNode target) {
                return BooleanNode.valueOf(from.getDoubleValue() != 0.0);
            }
        });
        toBooleanCoercers.put(TextNode.class, new TypeMapper<TextNode, BooleanNode>(BooleanNode.class){

            @Override
            public BooleanNode mapTo(TextNode from, BooleanNode target) {
                return BooleanNode.valueOf(from.length() > 0);
            }
        });
        toBooleanCoercers.put(NullNode.class, new TypeMapper<NullNode, BooleanNode>(BooleanNode.class){

            @Override
            public BooleanNode mapTo(NullNode from, BooleanNode target) {
                return BooleanNode.FALSE;
            }
        });
        toBooleanCoercers.put(MissingNode.class, new TypeMapper<MissingNode, BooleanNode>(BooleanNode.class){

            @Override
            public BooleanNode mapTo(MissingNode from, BooleanNode target) {
                return BooleanNode.FALSE;
            }
        });
        toBooleanCoercers.put(IArrayNode.class, new TypeMapper<IArrayNode<?>, BooleanNode>(BooleanNode.class){

            @Override
            public BooleanNode mapTo(IArrayNode<?> from, BooleanNode target) {
                return BooleanNode.valueOf(from.size() > 0);
            }
        });
        toBooleanCoercers.put(IObjectNode.class, new TypeMapper<IObjectNode, BooleanNode>(BooleanNode.class){

            @Override
            public BooleanNode mapTo(IObjectNode from, BooleanNode target) {
                return BooleanNode.valueOf(from.size() > 0);
            }
        });
        return toBooleanCoercers;
    }

    private Map<Class<? extends IJsonNode>, TypeMapper<?, TextNode>> getToStringCoercers() {
        IdentityHashMap toStringCoercers = new IdentityHashMap();
        toStringCoercers.put(IJsonNode.class, new TypeMapper<IJsonNode, TextNode>(TextNode.class){

            @Override
            public TextNode mapTo(IJsonNode from, TextNode target) {
                target.setValue(from.toString());
                return target;
            }
        });
        toStringCoercers.put(NullNode.class, new TypeMapper<IJsonNode, TextNode>(TextNode.class){

            @Override
            public TextNode mapTo(IJsonNode from, TextNode target) {
                target.setValue("");
                return target;
            }
        });
        return toStringCoercers;
    }

    private static final class SelfCoercer
    extends TypeMapper<IJsonNode, IJsonNode> {
        public SelfCoercer(Class<? extends IJsonNode> defaultType) {
            super(defaultType);
        }

        @Override
        public IJsonNode mapTo(IJsonNode node, IJsonNode target) {
            target.copyValueFrom(node);
            return target;
        }
    }

    private static final class CopyCoercer
    extends TypeMapper<IJsonNode, IJsonNode> {
        public CopyCoercer() {
            super(null);
        }

        @Override
        public IJsonNode mapTo(IJsonNode node, IJsonNode target) {
            if (target == null) {
                target = (IJsonNode)ReflectUtil.newInstance(node.getClass());
            }
            target.copyValueFrom(node);
            return target;
        }
    }
}

