/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import eu.stratosphere.sopremo.type.AbstractJsonNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IPrimitiveNode;
import eu.stratosphere.sopremo.type.ReusingSerializer;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharList;
import java.io.IOException;
import java.util.Formatter;
import java.util.Locale;

@DefaultSerializer(value=TextNodeSerializer.class)
public class TextNode
extends AbstractJsonNode
implements IPrimitiveNode,
CharSequence,
Appendable {
    public static final TextNode EMPTY_STRING = new TextNode("");
    private final CharArrayList value = new CharArrayList();
    private transient Formatter formatter;

    public TextNode() {
    }

    public TextNode(CharSequence v) {
        int count = v.length();
        for (int index = 0; index < count; ++index) {
            this.value.add(v.charAt(index));
        }
    }

    @Override
    public Appendable append(char c) {
        this.value.add(c);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq) {
        int count = csq.length();
        for (int index = 0; index < count; ++index) {
            this.value.add(csq.charAt(index));
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        for (int index = start; index < end; ++index) {
            this.value.add(csq.charAt(index));
        }
        return this;
    }

    public void append(long number) {
        this.asFormatter().format("%d", number);
    }

    public Appendable append(TextNode csq) {
        this.value.addAll((CharList)csq.value);
        return this;
    }

    public Appendable append(TextNode csq, int start, int end) {
        this.value.addElements(this.value.size(), csq.value.elements(), start, end);
        return this;
    }

    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append(this);
    }

    public Formatter asFormatter() {
        if (this.formatter == null) {
            this.formatter = new Formatter(this, Locale.US);
        }
        return this.formatter;
    }

    @Override
    public char charAt(int index) {
        return this.value.getChar(index);
    }

    @Override
    public void clear() {
        this.value.clear();
    }

    @Override
    public int compareToSameType(IJsonNode other) {
        TextNode otherNode = (TextNode)other;
        int len1 = this.value.size();
        int len2 = otherNode.value.size();
        int n = Math.min(len1, len2);
        char[] v1 = this.value.elements();
        char[] v2 = otherNode.value.elements();
        for (int index = 0; index < n; ++index) {
            if (v1[index] == v2[index]) continue;
            return v1[index] - v2[index];
        }
        return len1 - len2;
    }

    public boolean contentEquals(CharSequence seq) {
        int count = seq.length();
        if (this.value.size() != count) {
            return false;
        }
        for (int index = 0; index < count; ++index) {
            if (this.value.get(index).charValue() == seq.charAt(index)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void copyValueFrom(IJsonNode otherNode) {
        if (this == otherNode) {
            return;
        }
        this.checkForSameType(otherNode);
        this.value.clear();
        this.value.addAll((CharList)((TextNode)otherNode).value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextNode other = (TextNode)obj;
        return this.value.equals(other.value);
    }

    public Class<TextNode> getType() {
        return TextNode.class;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    public int indexOf(int thisFromIndex, int thisEndIndex, TextNode needle, int needleFromIndex, int needleToIndex) {
        int searchLength = needleToIndex - needleFromIndex;
        if (searchLength <= 0) {
            return thisFromIndex;
        }
        int maxIndex = thisEndIndex - searchLength;
        char[] needleValue = needle.value.elements();
        char[] value = this.value.elements();
        block0: for (int startIndex = thisFromIndex; startIndex <= maxIndex; ++startIndex) {
            if (value[startIndex] != needleValue[needleFromIndex]) continue;
            for (int pos = 1; pos < searchLength; ++pos) {
                if (value[startIndex + pos] != needleValue[needleFromIndex + pos]) continue block0;
            }
            return startIndex;
        }
        return -1;
    }

    public int indexOf(TextNode needle) {
        return this.indexOf(0, this.value.size(), needle, 0, needle.length());
    }

    @Override
    public int length() {
        return this.value.size();
    }

    public void setLength(int newLength) {
        this.value.size(newLength);
    }

    public void setValue(CharSequence value) {
        this.value.clear();
        int count = value.length();
        for (int index = 0; index < count; ++index) {
            this.value.add(value.charAt(index));
        }
    }

    public void setValue(CharSequence text, int start, int end) {
        this.value.clear();
        for (int index = start; index < end; ++index) {
            this.value.add(text.charAt(index));
        }
    }

    public void setValue(TextNode text, int start, int end) {
        this.value.size(end - start);
        System.arraycopy(text.value.elements(), start, this.value.elements(), 0, end - start);
    }

    @Override
    public CharSequence subSequence(final int start, final int end) {
        return new CharSequence(){

            @Override
            public char charAt(int index) {
                return TextNode.this.charAt(start + index);
            }

            @Override
            public int length() {
                return end - start;
            }

            @Override
            public CharSequence subSequence(int s, int e) {
                return TextNode.this.subSequence(start + e, end - e);
            }

            @Override
            public String toString() {
                return new StringBuilder(this).toString();
            }
        };
    }

    public char[] toArray() {
        return this.value.toCharArray();
    }

    public static TextNode valueOf(String v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (v.length() == 0) {
            return EMPTY_STRING;
        }
        return new TextNode(v);
    }

    public static class TextNodeSerializer
    extends ReusingSerializer<TextNode> {
        public TextNode copy(Kryo kryo, TextNode original) {
            return new TextNode(original);
        }

        @Override
        public TextNode read(Kryo kryo, Input input, TextNode oldInstance, Class<TextNode> type) {
            String string = input.readString();
            if (oldInstance == null) {
                return new TextNode(string);
            }
            oldInstance.value.clear();
            oldInstance.value.addElements(0, string.toCharArray());
            return oldInstance;
        }

        public void write(Kryo kryo, Output output, TextNode object) {
            output.writeString((CharSequence)object);
        }
    }
}

