/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import eu.stratosphere.util.ReflectionUtil;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class TemporaryVariableFactory {
    public static final TemporaryVariableFactory INSTANCE = new TemporaryVariableFactory();
    private final ThreadLocal<Map<Class<?>, Queue<Object>>> cachedObjects = new ThreadLocal<Map<Class<?>, Queue<Object>>>(){

        @Override
        protected Map<Class<?>, Queue<Object>> initialValue() {
            return new IdentityHashMap();
        }
    };

    public <T> T alllocateVariable(Class<T> type) {
        Queue<Object> objectList = this.getValueList(type);
        Object oldObject = objectList.poll();
        return (T)(oldObject == null ? ReflectionUtil.newInstance(type) : oldObject);
    }

    public void free(Object object) {
        this.getValueList(object.getClass()).offer(object);
    }

    private final Queue<Object> getValueList(Class<?> type) {
        Map<Class<?>, Queue<Object>> classToInstances = this.cachedObjects.get();
        Queue<Object> objectList = classToInstances.get(type);
        if (objectList == null) {
            objectList = new LinkedList<Object>();
            classToInstances.put(type, objectList);
        }
        return objectList;
    }
}

