/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.google.common.collect.Iterators;
import eu.stratosphere.sopremo.type.AbstractArrayNode;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.util.Iterator;

@DefaultSerializer(value=AbstractArrayNode.ArraySerializer.class)
public class SubArrayNode<T extends IJsonNode>
extends AbstractArrayNode<T> {
    private IArrayNode<T> originalArray = ArrayNode.EMPTY;
    private int startIndex;
    private int length;

    @Override
    public IArrayNode<T> add(int index, T element) {
        this.originalArray.add(this.startIndex + index, element);
        ++this.length;
        return this;
    }

    @Override
    public IArrayNode<T> add(T node) {
        this.originalArray.add(this.startIndex + this.length, node);
        ++this.length;
        return this;
    }

    @Override
    public void clear() {
        while (this.length > 0) {
            this.originalArray.remove(this.startIndex);
            --this.length;
        }
    }

    @Override
    public T get(int index) {
        return this.originalArray.get(this.startIndex + index);
    }

    public void init(IArrayNode<T> originalArray, int startIndex) {
        this.init(originalArray, startIndex, originalArray.size() - startIndex);
    }

    public void init(IArrayNode<T> originalArray, int startIndex, int length) {
        if (startIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.originalArray = originalArray;
        this.startIndex = startIndex;
        this.length = length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator iterator = this.originalArray.iterator();
        Iterators.advance((Iterator)iterator, (int)this.startIndex);
        return Iterators.limit((Iterator)iterator, (int)this.length);
    }

    @Override
    public void remove(int index) {
        if (index < 0 || index >= this.size()) {
            return;
        }
        --this.length;
        this.originalArray.remove(this.startIndex + index);
    }

    @Override
    public void set(int index, T node) {
        this.originalArray.set(this.startIndex + index, node);
    }

    @Override
    public void setSize(int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }
}

