/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import eu.stratosphere.sopremo.type.AbstractJsonNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IStreamNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

@DefaultSerializer(value=StreamNodeSerializer.class)
public class StreamNode<T extends IJsonNode>
extends AbstractJsonNode
implements IStreamNode<T> {
    private transient Iterator<T> nodeIterator;
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_SET.iterator();

    public StreamNode() {
        this(EMPTY_ITERATOR);
    }

    public StreamNode(Iterator<? extends T> nodeIterator) {
        this.nodeIterator = nodeIterator;
    }

    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append('[');
        Iterator<T> iterator = this.nodeIterator;
        if (iterator.hasNext()) {
            ArrayList<IJsonNode> elements = new ArrayList<IJsonNode>();
            while (iterator.hasNext()) {
                elements.add(((IJsonNode)iterator.next()).clone());
            }
            ((IJsonNode)elements.get(0)).appendAsString(appendable);
            for (int index = 1; index < elements.size() && index < 100; ++index) {
                appendable.append(", ");
                ((IJsonNode)elements.get(index)).appendAsString(appendable);
            }
            if (elements.size() > 100) {
                appendable.append(", ...");
            }
            this.nodeIterator = elements.iterator();
        }
        appendable.append(']');
    }

    @Override
    public void clear() {
        this.nodeIterator = EMPTY_ITERATOR;
    }

    @Override
    public int compareToSameType(IJsonNode other) {
        return System.identityHashCode(this) - System.identityHashCode(other);
    }

    @Override
    public void copyValueFrom(IJsonNode otherNode) {
        throw new UnsupportedOperationException();
    }

    public Iterator<? extends T> getNodeIterator() {
        return this.nodeIterator;
    }

    public Class<IArrayNode<T>> getType() {
        return IArrayNode.class;
    }

    @Override
    public int hashCode() {
        return 42;
    }

    @Override
    public boolean isEmpty() {
        return !this.nodeIterator.hasNext();
    }

    @Override
    public Iterator<T> iterator() {
        return this.nodeIterator;
    }

    public void setNodeIterator(Iterator<? extends T> nodeIterator) {
        if (nodeIterator == null) {
            throw new NullPointerException("nodeIterator must not be null");
        }
        this.nodeIterator = nodeIterator;
    }

    public static class StreamNodeSerializer
    extends Serializer<StreamNode<?>> {
        public StreamNode<?> copy(Kryo kryo, StreamNode<?> original) {
            return original;
        }

        public StreamNode<?> read(Kryo kryo, Input input, Class<StreamNode<?>> type) {
            throw new UnsupportedOperationException();
        }

        public void write(Kryo kryo, Output output, StreamNode<?> object) {
            throw new UnsupportedOperationException("Use CoreFunctions#ALL to transform this stream array into a materialized array");
        }
    }
}

