/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IStreamNode;
import eu.stratosphere.sopremo.type.StreamNode;
import java.util.Collections;
import java.util.Iterator;

public class PullingStreamNode<T extends IJsonNode>
extends StreamNode<T> {
    private Iterator<IJsonNode> source;
    private EvaluationExpression expression = null;
    private Iterator<T> iterator = Collections.EMPTY_SET.iterator();

    @Override
    public boolean isEmpty() {
        return !this.iterator.hasNext();
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    public void setExpression(EvaluationExpression expression) {
        this.expression = expression;
    }

    public void setSource(IStreamNode<?> node) {
        this.source = node.iterator();
        this.iterator = Iterators.transform(this.source, (Function)new Function<IJsonNode, T>(){

            public T apply(IJsonNode inputNode) {
                return PullingStreamNode.this.expression.evaluate(inputNode);
            }
        });
    }
}

