/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoCopyable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.type.AbstractJsonNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.ReusingSerializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import javolution.util.FastSet;

@DefaultSerializer(value=ObjectSerializer.class)
public class ObjectNode
extends AbstractJsonNode
implements IObjectNode,
KryoCopyable<ObjectNode> {
    private final SortedMap<String, IJsonNode> children = new TreeMap<String, IJsonNode>();

    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("{");
        boolean first = true;
        Iterator<Map.Entry<String, IJsonNode>> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (first) {
                first = false;
            } else {
                appendable.append(", ");
            }
            Map.Entry<String, IJsonNode> child = iterator.next();
            appendable.append(child.getKey()).append(": ");
            child.getValue().appendAsString(appendable);
        }
        appendable.append("}");
    }

    @Override
    public void clear() {
        this.children.clear();
    }

    @Override
    public ObjectNode clone() {
        return (ObjectNode)super.clone();
    }

    @Override
    public int compareToSameType(IJsonNode other) {
        IObjectNode node = (IObjectNode)other;
        Iterator<Map.Entry<String, IJsonNode>> entries1 = this.iterator();
        Iterator<Map.Entry<String, IJsonNode>> entries2 = node.iterator();
        while (entries1.hasNext() && entries2.hasNext()) {
            Map.Entry<String, IJsonNode> entry1 = entries1.next();
            Map.Entry<String, IJsonNode> entry2 = entries2.next();
            int keyComparison = entry1.getKey().compareTo(entry2.getKey());
            if (keyComparison != 0) {
                return keyComparison;
            }
            int valueComparison = entry1.getValue().compareTo(entry2.getValue());
            if (valueComparison == 0) continue;
            return valueComparison;
        }
        if (!entries1.hasNext()) {
            return entries2.hasNext() ? -1 : 0;
        }
        if (!entries2.hasNext()) {
            return 1;
        }
        return 0;
    }

    public ObjectNode copy(Kryo kryo) {
        ObjectNode node = new ObjectNode();
        node.copyValueFrom(this);
        return node;
    }

    @Override
    public void copyValueFrom(IJsonNode otherNode) {
        this.checkForSameType(otherNode);
        IObjectNode objectNode = (IObjectNode)otherNode;
        this.clear();
        for (Map.Entry<String, IJsonNode> child : objectNode) {
            this.put(child.getKey(), child.getValue().clone());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return super.equals(obj);
        }
        ObjectNode other = (ObjectNode)obj;
        return this.children.equals(other.children);
    }

    public IJsonNode get(String fieldName) {
        IJsonNode node = (IJsonNode)this.children.get(fieldName);
        if (node != null) {
            return node;
        }
        return MissingNode.getInstance();
    }

    @Override
    public SortedSet<String> getFieldNames() {
        return (SortedSet)this.children.keySet();
    }

    public final Class<IObjectNode> getType() {
        return IObjectNode.class;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.children.hashCode();
        return result;
    }

    @Override
    public Iterator<Map.Entry<String, IJsonNode>> iterator() {
        return this.children.entrySet().iterator();
    }

    @Override
    public ObjectNode put(String fieldName, IJsonNode value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == MissingNode.getInstance()) {
            this.children.remove(fieldName);
        } else {
            this.children.put(fieldName, value);
        }
        return this;
    }

    @Override
    public IObjectNode putAll(IObjectNode jsonNode) {
        for (Map.Entry<String, IJsonNode> entry : jsonNode) {
            this.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public void remove(String fieldName) {
        this.children.remove(fieldName);
    }

    @Override
    public int size() {
        return this.children.size();
    }

    public static final class ObjectSerializer
    extends ReusingSerializer<ObjectNode> {
        private final Set<String> currentKeys = new FastSet();

        @Override
        public ObjectNode read(Kryo kryo, Input input, Class<ObjectNode> type) {
            int len = input.readInt();
            ObjectNode object = new ObjectNode();
            for (int i = 0; i < len; ++i) {
                String key = input.readString();
                object.put(key, (IJsonNode)kryo.readClassAndObject(input));
            }
            return object;
        }

        @Override
        public ObjectNode read(Kryo kryo, Input input, ObjectNode object, Class<ObjectNode> type) {
            if (object == null) {
                return this.read(kryo, input, (Class)type);
            }
            int len = input.readInt();
            SortedMap children = object.children;
            this.currentKeys.addAll(children.keySet());
            for (int i = 0; i < len; ++i) {
                String key = input.readString();
                this.currentKeys.remove(key);
                children.put(key, SopremoUtil.deserializeInto(kryo, input, children.get(key)));
            }
            for (String currentKey : this.currentKeys) {
                children.remove(currentKey);
            }
            this.currentKeys.clear();
            return object;
        }

        public void write(Kryo kryo, Output output, ObjectNode object) {
            output.writeInt(object.size());
            for (Map.Entry<String, IJsonNode> entry : object) {
                output.writeString(entry.getKey());
                kryo.writeClassAndObject(output, (Object)entry.getValue());
            }
        }
    }
}

