/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import eu.stratosphere.sopremo.type.BigIntegerNode;
import eu.stratosphere.sopremo.type.DecimalNode;
import eu.stratosphere.sopremo.type.DoubleNode;
import eu.stratosphere.sopremo.type.INumericNode;
import eu.stratosphere.sopremo.type.IntNode;
import eu.stratosphere.sopremo.type.LongNode;
import eu.stratosphere.sopremo.type.TypeMapper;
import java.util.IdentityHashMap;
import java.util.Map;

public final class NumberCoercer {
    public static final NumberCoercer INSTANCE = new NumberCoercer();
    private final Map<Class<? extends INumericNode>, TypeMapper<? extends INumericNode, ? extends INumericNode>> coercers = new IdentityHashMap<Class<? extends INumericNode>, TypeMapper<? extends INumericNode, ? extends INumericNode>>();

    public NumberCoercer() {
        this.coercers.put(IntNode.class, (TypeMapper<? extends INumericNode, ? extends INumericNode>)new TypeMapper<INumericNode, IntNode>(IntNode.class){

            @Override
            public IntNode mapTo(INumericNode from, IntNode target) {
                target.setValue(from.getIntValue());
                return target;
            }
        });
        this.coercers.put(LongNode.class, (TypeMapper<? extends INumericNode, ? extends INumericNode>)new TypeMapper<INumericNode, LongNode>(LongNode.class){

            @Override
            public LongNode mapTo(INumericNode from, LongNode target) {
                target.setValue(from.getLongValue());
                return target;
            }
        });
        this.coercers.put(DoubleNode.class, (TypeMapper<? extends INumericNode, ? extends INumericNode>)new TypeMapper<INumericNode, DoubleNode>(DoubleNode.class){

            @Override
            public DoubleNode mapTo(INumericNode from, DoubleNode target) {
                target.setValue(from.getDoubleValue());
                return target;
            }
        });
        this.coercers.put(DecimalNode.class, (TypeMapper<? extends INumericNode, ? extends INumericNode>)new TypeMapper<INumericNode, DecimalNode>(DecimalNode.class){

            @Override
            public DecimalNode mapTo(INumericNode from, DecimalNode target) {
                target.setValue(from.getDecimalValue());
                return target;
            }
        });
        this.coercers.put(BigIntegerNode.class, (TypeMapper<? extends INumericNode, ? extends INumericNode>)new TypeMapper<INumericNode, BigIntegerNode>(BigIntegerNode.class){

            @Override
            public BigIntegerNode mapTo(INumericNode from, BigIntegerNode target) {
                target.setValue(from.getBigIntegerValue());
                return target;
            }
        });
    }

    public <From extends INumericNode, To extends INumericNode> To coerce(From node, To target, Class<To> targetType) {
        if (node.getClass() == targetType) {
            return (To)node;
        }
        TypeMapper<? extends INumericNode, ? extends INumericNode> coercer = this.coercers.get(targetType);
        return (To)coercer.mapTo(node, target);
    }

    Map<Class<? extends INumericNode>, TypeMapper<? extends INumericNode, ? extends INumericNode>> getCoercers() {
        return this.coercers;
    }
}

