/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import eu.stratosphere.sopremo.type.AbstractNumericNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.INumericNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javolution.text.TypeFormat;

public class LongNode
extends AbstractNumericNode
implements INumericNode {
    private long value;

    public LongNode() {
        this(0L);
    }

    public LongNode(long value) {
        this.value = value;
    }

    public void appendAsString(Appendable appendable) throws IOException {
        TypeFormat.format((long)this.value, (Appendable)appendable);
    }

    @Override
    public void clear() {
        this.value = 0L;
    }

    @Override
    public int compareToSameType(IJsonNode other) {
        long thisVal = this.value;
        long anotherVal = ((LongNode)other).value;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    @Override
    public void copyValueFrom(IJsonNode otherNode) {
        LongNode.checkNumber(otherNode);
        this.value = ((INumericNode)otherNode).getLongValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongNode other = (LongNode)obj;
        return this.value == other.value;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public BigDecimal getDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public byte getGeneralilty() {
        return 32;
    }

    @Override
    public int getIntValue() {
        return (int)this.value;
    }

    @Override
    public Long getJavaValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    public Class<LongNode> getType() {
        return LongNode.class;
    }

    @Override
    public String getValueAsText() {
        return String.valueOf(this.value);
    }

    @Override
    public int hashCode() {
        return (int)(this.value >>> 32) | (int)(this.value & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean isIntegralNumber() {
        return true;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public static LongNode valueOf(long value) {
        return new LongNode(value);
    }
}

