/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import eu.stratosphere.sopremo.expressions.ArrayAccess;
import eu.stratosphere.sopremo.expressions.ArrayProjection;
import eu.stratosphere.sopremo.expressions.ExpressionUtil;
import eu.stratosphere.sopremo.expressions.InputSelection;
import eu.stratosphere.sopremo.expressions.ObjectAccess;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IStreamNode;
import eu.stratosphere.sopremo.type.JavaToJsonMapper;
import eu.stratosphere.sopremo.type.ObjectNode;
import eu.stratosphere.sopremo.type.StreamNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JsonUtil {
    public static final JavaToJsonMapper OBJECT_MAPPER = new JavaToJsonMapper();

    public static IArrayNode<IJsonNode> asArray(IJsonNode ... nodes) {
        return new ArrayNode(nodes);
    }

    public static IArrayNode<?> createArrayNode(Object ... constants) {
        return (IArrayNode)OBJECT_MAPPER.map(constants);
    }

    public static IArrayNode<IJsonNode> createCompactArray(Object ... constants) {
        IJsonNode[] nodes = new IJsonNode[constants.length];
        for (int index = 0; index < nodes.length; ++index) {
            nodes[index] = JsonUtil.createValueNode(constants[index]);
        }
        return JsonUtil.asArray(nodes);
    }

    public static ObjectNode createObjectNode(Object ... fields) {
        if (fields.length % 2 != 0) {
            throw new IllegalArgumentException("must have an even number of params");
        }
        ObjectNode objectNode = new ObjectNode();
        for (int index = 0; index < fields.length; index += 2) {
            objectNode.put(fields[index].toString(), OBJECT_MAPPER.map(fields[index + 1]));
        }
        return objectNode;
    }

    public static PathSegmentExpression createPath(List<String> parts) {
        ArrayList<PathSegmentExpression> fragments = new ArrayList<PathSegmentExpression>();
        for (int index = 0; index < parts.size(); ++index) {
            PathSegmentExpression segment;
            String part = parts.get(index);
            if (part.matches("[0-9]+")) {
                segment = new InputSelection(Integer.parseInt(part));
            } else if (part.matches("\\[.*\\]")) {
                if (part.charAt(1) == '*') {
                    segment = new ArrayProjection(JsonUtil.createPath(parts.subList(index + 1, parts.size())));
                    index = parts.size();
                } else if (part.contains(":")) {
                    int delim = part.indexOf(":");
                    segment = new ArrayAccess(Integer.parseInt(part.substring(1, delim)), Integer.parseInt(part.substring(delim + 1, part.length() - 1)));
                } else {
                    segment = new ArrayAccess(Integer.parseInt(part.substring(1, part.length() - 1)));
                }
            } else {
                segment = new ObjectAccess(part);
            }
            fragments.add(segment);
        }
        return ExpressionUtil.makePath(fragments);
    }

    public static PathSegmentExpression createPath(String ... parts) {
        return JsonUtil.createPath(Arrays.asList(parts));
    }

    public static IStreamNode<?> createStreamArrayNode(Object ... constants) {
        return new StreamNode(JsonUtil.createArrayNode(constants).iterator());
    }

    public static IJsonNode createValueNode(Object value) {
        return OBJECT_MAPPER.map(value);
    }
}

