/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import eu.stratosphere.sopremo.type.AbstractTypeMapper;
import eu.stratosphere.sopremo.type.BigIntegerNode;
import eu.stratosphere.sopremo.type.BooleanNode;
import eu.stratosphere.sopremo.type.DecimalNode;
import eu.stratosphere.sopremo.type.DoubleNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.INumericNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.IntNode;
import eu.stratosphere.sopremo.type.JavaToJsonMapper;
import eu.stratosphere.sopremo.type.LongNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.NullNode;
import eu.stratosphere.sopremo.type.TextNode;
import eu.stratosphere.sopremo.type.TypeMapper;
import eu.stratosphere.sopremo.type.typed.ITypedObjectNode;
import eu.stratosphere.util.CollectionUtil;
import eu.stratosphere.util.reflect.ReflectUtil;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonToJavaMapper
extends AbstractTypeMapper<TypeMapper<?, ?>> {
    private static final TypeMapper<INumericNode, Number> DefaultNumberMapper = new TypeMapper<INumericNode, Number>(null){

        @Override
        public Number mapTo(INumericNode from, Number target) {
            return from.getJavaValue();
        }
    };
    public static final JsonToJavaMapper INSTANCE = new JsonToJavaMapper();

    protected JsonToJavaMapper() {
        this.addDefaultTypeMapping((Type)((Object)IntNode.class), (Type)((Object)Integer.class));
        this.addDefaultTypeMapping((Type)((Object)LongNode.class), (Type)((Object)Long.class));
        this.addDefaultTypeMapping((Type)((Object)BigIntegerNode.class), (Type)((Object)BigInteger.class));
        this.addDefaultTypeMapping((Type)((Object)DecimalNode.class), (Type)((Object)BigDecimal.class));
        this.addDefaultTypeMapping((Type)((Object)DoubleNode.class), (Type)((Object)Double.class));
        this.addDefaultTypeMapping((Type)((Object)TextNode.class), (Type)((Object)String.class));
        this.addDefaultTypeMapping((Type)((Object)BooleanNode.class), (Type)((Object)Boolean.class));
        this.addDefaultTypeMapping((Type)((Object)IObjectNode.class), (Type)((Object)Map.class));
        this.addDefaultTypeMapping((Type)((Object)IArrayNode.class), (Type)((Object)List.class));
        this.addMissingAndNullMappers();
        this.addBooleanMappers();
        this.addStringMappers();
        this.addIntegerMappers();
        this.addLongMappers();
        this.addDoubleMappers();
        this.addMapper((Type)((Object)DecimalNode.class), (Type)((Object)BigDecimal.class), DefaultNumberMapper);
        this.addMapper((Type)((Object)BigIntegerNode.class), (Type)((Object)BigInteger.class), DefaultNumberMapper);
        this.addGeneralMappers();
    }

    public <F extends IJsonNode, T> TypeMapper<F, T> getMapper(Class<F> fromClass, Class<T> targetType) {
        return (TypeMapper)super.getMapper(fromClass, targetType);
    }

    public <T> T map(IJsonNode from) {
        return this.map(from, null, this.getDefaultMappingType(from.getClass()));
    }

    public <T> T map(IJsonNode from, T to) {
        return this.map(from, to, this.getDefaultMappingType(from.getClass()));
    }

    public <T> T map(IJsonNode from, T to, Class<T> targetType) {
        return this.map(from, to, (Type)targetType);
    }

    public <T> T map(IJsonNode from, T to, Type targetType) {
        TypeMapper targetMapper = (TypeMapper)this.getMapper(from.getClass(), targetType);
        if (targetMapper == null) {
            throw new IllegalArgumentException(String.format("Cannot map %s to %s", from, targetType));
        }
        if (to == null && targetMapper.getDefaultType() != null) {
            to = ReflectUtil.newInstance(targetMapper.getDefaultType());
        }
        return targetMapper.mapTo(from, to);
    }

    @Override
    protected Type findDefaultMappingType(Class<?> fromClass) {
        if (fromClass.isArray()) {
            return IArrayNode.class;
        }
        if (ITypedObjectNode.class.isAssignableFrom(fromClass)) {
            return fromClass;
        }
        return super.findDefaultMappingType(fromClass);
    }

    @Override
    protected TypeMapper<?, ?> findMapper(Class<?> fromClass, Class<?> originalFromClass, Type targetType, Class<?> rawTarget) {
        TypeMapper mapper;
        if (rawTarget.isArray()) {
            mapper = new ArrayToArrayMapper(targetType);
            this.addMapper(fromClass, rawTarget, mapper);
        } else if (Collection.class.isAssignableFrom(rawTarget)) {
            mapper = new ArrayToListMapper(targetType);
            this.addMapper(fromClass, rawTarget, mapper);
        } else if (rawTarget.isEnum()) {
            mapper = new EnumMapper(targetType);
            this.addMapper(fromClass, rawTarget, mapper);
        } else if (fromClass == rawTarget) {
            mapper = JavaToJsonMapper.SelfMapper;
            this.addMapper(fromClass, fromClass, mapper);
        } else if (Map.class.isAssignableFrom(rawTarget)) {
            mapper = new ObjectToMapMapper(targetType);
            this.addMapper(fromClass, rawTarget, mapper);
        } else {
            mapper = (TypeMapper)super.findMapper(fromClass, originalFromClass, targetType, rawTarget);
        }
        return mapper;
    }

    private void addBooleanMappers() {
        TypeMapper<BooleanNode, Boolean> toBooleanMapper = new TypeMapper<BooleanNode, Boolean>(null){

            @Override
            public Boolean mapTo(BooleanNode from, Boolean target) {
                return from.getBooleanValue();
            }
        };
        this.addMapper((Type)((Object)BooleanNode.class), (Type)((Object)Boolean.class), toBooleanMapper);
        this.addMapper((Type)((Object)BooleanNode.class), Boolean.TYPE, toBooleanMapper);
    }

    private void addDoubleMappers() {
        this.addMapper((Type)((Object)DoubleNode.class), (Type)((Object)Double.class), DefaultNumberMapper);
        this.addMapper((Type)((Object)DoubleNode.class), Double.TYPE, DefaultNumberMapper);
        TypeMapper<INumericNode, Float> fromFloat = new TypeMapper<INumericNode, Float>(null){

            @Override
            public Float mapTo(INumericNode from, Float target) {
                return Float.valueOf((float)from.getDoubleValue());
            }
        };
        this.addMapper((Type)((Object)DoubleNode.class), (Type)((Object)Float.class), fromFloat);
        this.addMapper((Type)((Object)DoubleNode.class), Float.TYPE, fromFloat);
    }

    private void addGeneralMappers() {
        TypeMapper<IJsonNode, String> toStringMapper = new TypeMapper<IJsonNode, String>(null){

            @Override
            public String mapTo(IJsonNode from, String target) {
                return from.toString();
            }
        };
        this.addMapper((Type)((Object)IJsonNode.class), (Type)((Object)String.class), toStringMapper);
        this.addMapper((Type)((Object)IJsonNode.class), (Type)((Object)CharSequence.class), toStringMapper);
        this.addMapper((Type)((Object)IJsonNode.class), (Type)((Object)StringBuilder.class), new TypeMapper<IJsonNode, StringBuilder>(StringBuilder.class){

            @Override
            public StringBuilder mapTo(IJsonNode from, StringBuilder target) {
                target.setLength(0);
                try {
                    from.appendAsString(target);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return target;
            }
        });
    }

    private void addIntegerMappers() {
        this.addMapper((Type)((Object)IntNode.class), (Type)((Object)Integer.class), DefaultNumberMapper);
        this.addMapper((Type)((Object)IntNode.class), Integer.TYPE, DefaultNumberMapper);
        TypeMapper<INumericNode, Byte> toByte = new TypeMapper<INumericNode, Byte>(null){

            @Override
            public Byte mapTo(INumericNode from, Byte target) {
                return (byte)from.getIntValue();
            }
        };
        this.addMapper((Type)((Object)IntNode.class), (Type)((Object)Byte.class), toByte);
        this.addMapper((Type)((Object)IntNode.class), Byte.TYPE, toByte);
        TypeMapper<INumericNode, Short> toShort = new TypeMapper<INumericNode, Short>(null){

            @Override
            public Short mapTo(INumericNode from, Short target) {
                return (short)from.getIntValue();
            }
        };
        this.addMapper((Type)((Object)IntNode.class), (Type)((Object)Short.class), toShort);
        this.addMapper((Type)((Object)IntNode.class), Short.TYPE, toShort);
    }

    private void addLongMappers() {
        this.addMapper((Type)((Object)LongNode.class), (Type)((Object)Long.class), DefaultNumberMapper);
        this.addMapper((Type)((Object)LongNode.class), Long.TYPE, DefaultNumberMapper);
    }

    private void addMissingAndNullMappers() {
        TypeMapper<IJsonNode, Object> mapper = new TypeMapper<IJsonNode, Object>(null){

            @Override
            public Object mapTo(IJsonNode from, Object target) {
                return null;
            }
        };
        this.addMapper((Type)((Object)MissingNode.class), (Type)((Object)Object.class), mapper);
        this.addMapper((Type)((Object)NullNode.class), (Type)((Object)Object.class), mapper);
    }

    private void addStringMappers() {
        TypeMapper<TextNode, String> toStringMapper = new TypeMapper<TextNode, String>(null){

            @Override
            public String mapTo(TextNode from, String target) {
                return from.toString();
            }
        };
        this.addMapper((Type)((Object)TextNode.class), (Type)((Object)String.class), toStringMapper);
        this.addMapper((Type)((Object)TextNode.class), (Type)((Object)CharSequence.class), toStringMapper);
        this.addMapper((Type)((Object)TextNode.class), (Type)((Object)StringBuilder.class), new TypeMapper<TextNode, StringBuilder>(StringBuilder.class){

            @Override
            public StringBuilder mapTo(TextNode from, StringBuilder target) {
                target.setLength(0);
                target.append(from);
                return target;
            }
        });
        this.addMapper((Type)((Object)TextNode.class), (Type)((Object)StringBuffer.class), new TypeMapper<TextNode, StringBuffer>(StringBuffer.class){

            @Override
            public StringBuffer mapTo(TextNode from, StringBuffer target) {
                target.setLength(0);
                target.append(from);
                return target;
            }
        });
        this.addMapper((Type)((Object)TextNode.class), (Type)((Object)char[].class), new TypeMapper<TextNode, char[]>(null){

            @Override
            public char[] mapTo(TextNode from, char[] target) {
                return from.toArray();
            }
        });
    }

    private static final class ObjectToMapMapper
    extends TypeMapper<IObjectNode, Map> {
        private final Type valueType;
        private final Type keyType;
        private final Class<?> rawKeyType;
        private final ThreadLocal<Set> reusedKeys = new ThreadLocal<Set>(){

            @Override
            protected Set initialValue() {
                return new HashSet();
            }
        };

        public ObjectToMapMapper(Type targetType) {
            super(HashMap.class);
            if (targetType instanceof ParameterizedType) {
                this.keyType = ((ParameterizedType)targetType).getActualTypeArguments()[0];
                this.valueType = ((ParameterizedType)targetType).getActualTypeArguments()[1];
                this.rawKeyType = TypeToken.of((Type)this.keyType).getRawType();
            } else {
                this.rawKeyType = String.class;
                this.keyType = String.class;
                this.valueType = Object.class;
            }
        }

        @Override
        public Map mapTo(IObjectNode from, Map target) {
            Set reusedKeys = this.reusedKeys.get();
            if (this.rawKeyType == String.class) {
                reusedKeys.addAll(from.getFieldNames());
                for (String key : from.getFieldNames()) {
                    target.put(key, INSTANCE.map((IJsonNode)from.get(key), target.get(key), this.valueType));
                }
            } else {
                for (String key : from.getFieldNames()) {
                    Object targetKey = INSTANCE.map((IJsonNode)from.get(key), null, this.keyType);
                    target.put(targetKey, INSTANCE.map((IJsonNode)from.get(key), target.get(key), this.valueType));
                    reusedKeys.add(targetKey);
                }
            }
            Iterables.retainAll(target.keySet(), (Collection)reusedKeys);
            reusedKeys.clear();
            return target;
        }
    }

    private static class EnumMapper
    extends TypeMapper<TextNode, Enum<?>> {
        private final Map<TextNode, Enum<?>> values = new HashMap();
        private final Type targetType;

        private EnumMapper(Type targetType) {
            super(null);
            Enum[] enumConstants;
            this.targetType = targetType;
            for (Enum constant : enumConstants = (Enum[])((Class)targetType).getEnumConstants()) {
                this.values.put(TextNode.valueOf(constant.name()), constant);
            }
        }

        @Override
        public Enum<?> mapTo(TextNode from, Enum<?> target) {
            Enum<?> value = this.values.get(from);
            if (value == null) {
                throw new IllegalArgumentException(String.format("Unknown enum value %s for enum %s", from, this.targetType));
            }
            return value;
        }
    }

    private static final class ArrayToListMapper
    extends TypeMapper<IArrayNode, List> {
        private final Type elemType;

        private ArrayToListMapper(Type targetType) {
            super(ArrayList.class);
            this.elemType = targetType instanceof Class ? Object.class : ((ParameterizedType)targetType).getActualTypeArguments()[0];
        }

        @Override
        public List mapTo(IArrayNode from, List target) {
            int targetSize = from.size();
            CollectionUtil.ensureSize((Collection)target, (int)targetSize);
            if (this.elemType == Object.class) {
                for (int index = 0; index < targetSize; ++index) {
                    target.set(index, INSTANCE.map((IJsonNode)from.get(index), target.get(index)));
                }
            } else {
                for (int index = 0; index < targetSize; ++index) {
                    target.set(index, INSTANCE.map((IJsonNode)from.get(index), target.get(index), this.elemType));
                }
            }
            target.subList(targetSize, target.size()).clear();
            return target;
        }
    }

    private static final class ArrayToArrayMapper
    extends TypeMapper<IArrayNode, Object> {
        private final Class<?> rawElemType;
        private final Type elemType;

        private ArrayToArrayMapper(Type targetType) {
            super(null);
            this.elemType = targetType instanceof Class ? ((Class)targetType).getComponentType() : ((GenericArrayType)targetType).getGenericComponentType();
            this.rawElemType = this.elemType instanceof Class ? (Class)this.elemType : TypeToken.of((Type)this.elemType).getRawType();
        }

        @Override
        public Object mapTo(IArrayNode from, Object target) {
            int fromSize = from.size();
            if (target == null || fromSize != Array.getLength(from)) {
                target = Array.newInstance(this.rawElemType, fromSize);
            }
            for (int index = 0; index < fromSize; ++index) {
                Array.set(target, index, INSTANCE.map((IJsonNode)from.get(index), Array.get(target, index), this.elemType));
            }
            return target;
        }
    }
}

