/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import eu.stratosphere.sopremo.type.AbstractArrayNode;
import eu.stratosphere.sopremo.type.AbstractTypeMapper;
import eu.stratosphere.sopremo.type.BigIntegerNode;
import eu.stratosphere.sopremo.type.BooleanNode;
import eu.stratosphere.sopremo.type.CachingArrayNode;
import eu.stratosphere.sopremo.type.DecimalNode;
import eu.stratosphere.sopremo.type.DoubleNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.IntNode;
import eu.stratosphere.sopremo.type.LongNode;
import eu.stratosphere.sopremo.type.NullNode;
import eu.stratosphere.sopremo.type.ObjectNode;
import eu.stratosphere.sopremo.type.TextNode;
import eu.stratosphere.sopremo.type.TypeMapper;
import eu.stratosphere.util.reflect.ReflectUtil;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JavaToJsonMapper
extends AbstractTypeMapper<TypeMapper<?, ?>> {
    private static final Set<Class<?>> PrimitiveNumbers = new HashSet();
    public static final JavaToJsonMapper INSTANCE;
    static final TypeMapper<?, ?> SelfMapper;

    protected JavaToJsonMapper() {
        this.addDefaultTypeMapping((Type)((Object)Void.class), (Type)((Object)NullNode.class));
        this.addDefaultTypeMapping((Type)((Object)Integer.class), (Type)((Object)IntNode.class));
        this.addDefaultTypeMapping(Integer.TYPE, (Type)((Object)IntNode.class));
        this.addDefaultTypeMapping((Type)((Object)Short.class), (Type)((Object)IntNode.class));
        this.addDefaultTypeMapping(Short.TYPE, (Type)((Object)IntNode.class));
        this.addDefaultTypeMapping((Type)((Object)Byte.class), (Type)((Object)IntNode.class));
        this.addDefaultTypeMapping(Byte.TYPE, (Type)((Object)IntNode.class));
        this.addDefaultTypeMapping((Type)((Object)Long.class), (Type)((Object)LongNode.class));
        this.addDefaultTypeMapping(Long.TYPE, (Type)((Object)LongNode.class));
        this.addDefaultTypeMapping((Type)((Object)BigInteger.class), (Type)((Object)BigIntegerNode.class));
        this.addDefaultTypeMapping((Type)((Object)BigDecimal.class), (Type)((Object)DecimalNode.class));
        this.addDefaultTypeMapping((Type)((Object)Double.class), (Type)((Object)DoubleNode.class));
        this.addDefaultTypeMapping(Double.TYPE, (Type)((Object)DoubleNode.class));
        this.addDefaultTypeMapping((Type)((Object)Float.class), (Type)((Object)DoubleNode.class));
        this.addDefaultTypeMapping(Float.TYPE, (Type)((Object)DoubleNode.class));
        this.addDefaultTypeMapping((Type)((Object)CharSequence.class), (Type)((Object)TextNode.class));
        this.addDefaultTypeMapping((Type)((Object)Boolean.class), (Type)((Object)BooleanNode.class));
        this.addDefaultTypeMapping(Boolean.TYPE, (Type)((Object)BooleanNode.class));
        this.addDefaultTypeMapping((Type)((Object)Enum.class), (Type)((Object)TextNode.class));
        this.addDefaultTypeMapping((Type)((Object)Map.class), (Type)((Object)ObjectNode.class));
        this.addDefaultTypeMapping((Type)((Object)Collection.class), (Type)((Object)CachingArrayNode.class));
        this.addToIntMapper();
        this.addToDoubleMapper();
        this.addToLongMapper();
        this.addToBigDecimalMapper();
        this.addToBigIntegerMapper();
        this.addToStringMapper();
        this.addToBooleanMapper();
        this.addToObjectMapper();
    }

    public <F, T extends IJsonNode> TypeMapper<F, T> getMapper(Class<?> fromClass, Class<T> targetType) {
        return (TypeMapper)super.getMapper(fromClass, targetType);
    }

    public IJsonNode map(Object value) {
        if (value == null) {
            return NullNode.getInstance();
        }
        Type type = this.getDefaultMappingType(value.getClass());
        if (type == null) {
            throw new IllegalArgumentException("Cannot find appropriate json type for " + value);
        }
        return this.map(value, null, type);
    }

    public <T extends IJsonNode> T map(Object from, T to, Type targetType) {
        if (from == null) {
            return (T)NullNode.getInstance();
        }
        TypeMapper targetMapper = (TypeMapper)this.getMapper(from.getClass(), targetType);
        if (targetMapper == null) {
            throw new IllegalArgumentException(String.format("Cannot map %s to %s ", from, targetType));
        }
        return this.map(from, to, targetMapper);
    }

    @Override
    protected Type findDefaultMappingType(Class<?> fromClass) {
        if (fromClass.isArray() || Collection.class.isAssignableFrom(fromClass)) {
            return CachingArrayNode.class;
        }
        if (IJsonNode.class.isAssignableFrom(fromClass)) {
            return fromClass;
        }
        return super.findDefaultMappingType(fromClass);
    }

    @Override
    protected TypeMapper<?, ?> findMapper(Class<?> fromClass, Class<?> originalFromClass, Type targetType, Class<?> rawTarget) {
        if (fromClass.isArray()) {
            ArrayToArrayMapper mapper = new ArrayToArrayMapper(targetType);
            this.addMapper(fromClass, targetType, mapper);
            return mapper;
        }
        if (Collection.class.isAssignableFrom(fromClass)) {
            CollectionToArrayMapper mapper = new CollectionToArrayMapper(targetType);
            this.addMapper(fromClass, targetType, mapper);
            return mapper;
        }
        if (fromClass == rawTarget) {
            this.addMapper(fromClass, fromClass, SelfMapper);
            return SelfMapper;
        }
        return (TypeMapper)super.findMapper(fromClass, originalFromClass, targetType, rawTarget);
    }

    private void addToBigDecimalMapper() {
        TypeMapper<BigDecimal, DecimalNode> toBigDecimalMapper = new TypeMapper<BigDecimal, DecimalNode>(DecimalNode.class){

            @Override
            public DecimalNode mapTo(BigDecimal from, DecimalNode target) {
                target.setValue(from);
                return target;
            }
        };
        this.addMapper((Type)((Object)BigDecimal.class), (Type)((Object)DecimalNode.class), toBigDecimalMapper);
    }

    private void addToBigIntegerMapper() {
        TypeMapper<BigInteger, BigIntegerNode> toBigIntegerMapper = new TypeMapper<BigInteger, BigIntegerNode>(BigIntegerNode.class){

            @Override
            public BigIntegerNode mapTo(BigInteger from, BigIntegerNode target) {
                target.setValue(from);
                return target;
            }
        };
        this.addMapper((Type)((Object)BigInteger.class), (Type)((Object)BigIntegerNode.class), toBigIntegerMapper);
    }

    private void addToBooleanMapper() {
        TypeMapper<Boolean, BooleanNode> toBooleanMapper = new TypeMapper<Boolean, BooleanNode>(null){

            @Override
            public BooleanNode mapTo(Boolean from, BooleanNode target) {
                return BooleanNode.valueOf(from);
            }
        };
        this.addMapper((Type)((Object)Boolean.class), (Type)((Object)BooleanNode.class), toBooleanMapper);
        this.addMapper(Boolean.TYPE, (Type)((Object)BooleanNode.class), toBooleanMapper);
    }

    private void addToDoubleMapper() {
        TypeMapper<Number, DoubleNode> toDoubleMapper = new TypeMapper<Number, DoubleNode>(DoubleNode.class){

            @Override
            public DoubleNode mapTo(Number from, DoubleNode target) {
                target.setValue(from.doubleValue());
                return target;
            }
        };
        this.addMapper((Type)((Object)Number.class), (Type)((Object)DoubleNode.class), toDoubleMapper);
        for (Class<?> primitiveNumber : PrimitiveNumbers) {
            this.addMapper(primitiveNumber, (Type)((Object)DoubleNode.class), toDoubleMapper);
        }
    }

    private void addToIntMapper() {
        TypeMapper<Number, IntNode> toIntMapper = new TypeMapper<Number, IntNode>(IntNode.class){

            @Override
            public IntNode mapTo(Number from, IntNode target) {
                target.setValue(from.intValue());
                return target;
            }
        };
        this.addMapper((Type)((Object)Number.class), (Type)((Object)IntNode.class), toIntMapper);
        for (Class<?> primitiveNumber : PrimitiveNumbers) {
            this.addMapper(primitiveNumber, (Type)((Object)IntNode.class), toIntMapper);
        }
    }

    private void addToLongMapper() {
        TypeMapper<Number, LongNode> toLongMapper = new TypeMapper<Number, LongNode>(LongNode.class){

            @Override
            public LongNode mapTo(Number from, LongNode target) {
                target.setValue(from.longValue());
                return target;
            }
        };
        this.addMapper((Type)((Object)Number.class), (Type)((Object)LongNode.class), toLongMapper);
        for (Class<?> primitiveNumber : PrimitiveNumbers) {
            this.addMapper(primitiveNumber, (Type)((Object)LongNode.class), toLongMapper);
        }
    }

    private void addToObjectMapper() {
        TypeMapper toObjectMapper = new TypeMapper<Map<?, ?>, IObjectNode>(ObjectNode.class){
            Set<String> unusedKeys;
            {
                this.unusedKeys = new HashSet<String>();
            }

            @Override
            public IObjectNode mapTo(Map<?, ?> from, IObjectNode target) {
                this.unusedKeys.addAll(target.getFieldNames());
                for (Map.Entry<?, ?> entry : from.entrySet()) {
                    String targetKey = entry.getKey().toString();
                    target.put(targetKey, INSTANCE.map(entry.getValue()));
                    this.unusedKeys.remove(targetKey);
                }
                for (String key : this.unusedKeys) {
                    target.remove(key);
                }
                return target;
            }
        };
        this.addMapper((Type)((Object)Map.class), (Type)((Object)ObjectNode.class), toObjectMapper);
    }

    private void addToStringMapper() {
        TypeMapper<CharSequence, TextNode> charSeqToTextMapper = new TypeMapper<CharSequence, TextNode>(TextNode.class){

            @Override
            public TextNode mapTo(CharSequence from, TextNode target) {
                target.setValue(from);
                return target;
            }
        };
        this.addMapper((Type)((Object)CharSequence.class), (Type)((Object)TextNode.class), charSeqToTextMapper);
        TypeMapper<Object, TextNode> anyToTextMapper = new TypeMapper<Object, TextNode>(TextNode.class){

            @Override
            public TextNode mapTo(Object from, TextNode target) {
                target.setValue(from.toString());
                return target;
            }
        };
        this.addMapper((Type)((Object)Object.class), (Type)((Object)TextNode.class), anyToTextMapper);
        TypeMapper enumToTextMapper = new TypeMapper<Enum<?>, TextNode>(TextNode.class){

            @Override
            public TextNode mapTo(Enum<?> from, TextNode target) {
                target.setValue(from.name());
                return target;
            }
        };
        this.addMapper((Type)((Object)Enum.class), (Type)((Object)TextNode.class), enumToTextMapper);
    }

    private <T extends IJsonNode> T map(Object from, T to, TypeMapper<Object, T> targetMapper) {
        IJsonNode initializedTo = to != null && targetMapper.isValidTarget(to) ? (IJsonNode)to : (targetMapper.getDefaultType() != null ? (IJsonNode)ReflectUtil.newInstance(targetMapper.getDefaultType()) : null);
        return (T)targetMapper.mapTo(from, initializedTo);
    }

    static {
        for (Class primitive : Primitives.allPrimitiveTypes()) {
            if (!Number.class.isAssignableFrom(primitive)) continue;
            PrimitiveNumbers.add(primitive);
        }
        INSTANCE = new JavaToJsonMapper();
        SelfMapper = new TypeMapper<Object, Object>(null){

            @Override
            public Object mapTo(Object from, Object target) {
                return from;
            }
        };
    }

    private static final class CollectionToArrayMapper
    extends TypeMapper<Collection, IArrayNode> {
        private final Class<?> elemType;

        private CollectionToArrayMapper(Type targetType) {
            super(CachingArrayNode.class);
            Class<IJsonNode> elemType;
            Class<IJsonNode> clazz = elemType = targetType instanceof ParameterizedType ? TypeToken.of((Type)((ParameterizedType)targetType).getActualTypeArguments()[0]).getRawType() : IJsonNode.class;
            if (elemType == Object.class) {
                elemType = IJsonNode.class;
            }
            this.elemType = elemType;
        }

        @Override
        public IArrayNode mapTo(Collection from, IArrayNode target) {
            int targetSize = from.size();
            Iterator iterator = from.iterator();
            ((AbstractArrayNode)target).setSize(targetSize);
            for (int index = 0; index < targetSize; ++index) {
                target.set(index, INSTANCE.map(iterator.next(), target.get(index), this.elemType));
            }
            return target;
        }
    }

    private static class ArrayToArrayMapper
    extends TypeMapper<Object, IArrayNode> {
        private final Class<?> elemType;

        public ArrayToArrayMapper(Type targetType) {
            super(CachingArrayNode.class);
            Class<IJsonNode> elemType;
            Class<IJsonNode> clazz = elemType = targetType instanceof Class ? ((Class)targetType).getComponentType() : TypeToken.of((Type)((ParameterizedType)targetType).getActualTypeArguments()[0]).getRawType();
            if (elemType == null || elemType == Object.class) {
                elemType = IJsonNode.class;
            }
            this.elemType = elemType;
        }

        @Override
        public IArrayNode<IJsonNode> mapTo(Object from, IArrayNode target) {
            int targetSize = Array.getLength(from);
            if (target instanceof AbstractArrayNode) {
                ((AbstractArrayNode)target).setSize(targetSize);
                for (int index = 0; index < targetSize; ++index) {
                    target.set(index, INSTANCE.map(Array.get(from, index), target.get(index), this.elemType));
                }
            }
            return target;
        }
    }
}

