/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import eu.stratosphere.sopremo.type.AbstractNumericNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.INumericNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javolution.text.TypeFormat;

public class IntNode
extends AbstractNumericNode
implements INumericNode {
    private int value;
    public static final IntNode ZERO = new IntNode(0);
    public static final IntNode ONE = new IntNode(1);

    public IntNode() {
        this.value = 0;
    }

    public IntNode(int v) {
        this.value = v;
    }

    public void appendAsString(Appendable appendable) throws IOException {
        TypeFormat.format((int)this.value, (Appendable)appendable);
    }

    @Override
    public void clear() {
        this.value = 0;
    }

    @Override
    public int compareToSameType(IJsonNode other) {
        int thisVal = this.value;
        int anotherVal = ((IntNode)other).value;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    @Override
    public void copyValueFrom(IJsonNode otherNode) {
        IntNode.checkNumber(otherNode);
        this.value = ((INumericNode)otherNode).getIntValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntNode other = (IntNode)obj;
        return this.value == other.value;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public BigDecimal getDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public byte getGeneralilty() {
        return 16;
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    @Override
    public Integer getJavaValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    public Class<IntNode> getType() {
        return IntNode.class;
    }

    @Override
    public String getValueAsText() {
        return String.valueOf(this.value);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    public void increment() {
        ++this.value;
    }

    @Override
    public boolean isIntegralNumber() {
        return true;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public static IntNode valueOf(int v) {
        return new IntNode(v);
    }
}

