/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import eu.stratosphere.sopremo.type.AbstractNumericNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.INumericNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javolution.text.TypeFormat;

public class DoubleNode
extends AbstractNumericNode
implements INumericNode {
    private double value;
    public static final DoubleNode NaN = DoubleNode.valueOf(Double.NaN);

    public DoubleNode() {
    }

    public DoubleNode(double v) {
        this.value = v;
    }

    public DoubleNode(float v) {
        this.value = v;
    }

    public void appendAsString(Appendable appendable) throws IOException {
        TypeFormat.format((double)this.value, (Appendable)appendable);
    }

    @Override
    public void clear() {
        this.value = 0.0;
    }

    @Override
    public int compareToSameType(IJsonNode other) {
        return Double.compare(this.value, ((DoubleNode)other).value);
    }

    @Override
    public void copyValueFrom(IJsonNode otherNode) {
        DoubleNode.checkNumber(otherNode);
        this.value = ((INumericNode)otherNode).getDoubleValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleNode other = (DoubleNode)obj;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return BigInteger.valueOf(this.getLongValue());
    }

    @Override
    public BigDecimal getDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public byte getGeneralilty() {
        return 64;
    }

    @Override
    public int getIntValue() {
        return (int)this.value;
    }

    @Override
    public Double getJavaValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return (long)this.value;
    }

    public Class<DoubleNode> getType() {
        return DoubleNode.class;
    }

    @Override
    public String getValueAsText() {
        return String.valueOf(this.value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean isFloatingPointNumber() {
        return true;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public static DoubleNode valueOf(double v) {
        return new DoubleNode(v);
    }
}

