/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.NodeFactory;
import eu.stratosphere.sopremo.type.NullNode;
import eu.stratosphere.sopremo.type.ObjectNode;
import eu.stratosphere.util.reflect.ReflectUtil;
import java.util.IdentityHashMap;
import java.util.Map;

public class DefaultNodeFactory
implements NodeFactory {
    private static final DefaultNodeFactory Instance = new DefaultNodeFactory().register(IArrayNode.class, ArrayNode.class).register(IObjectNode.class, ObjectNode.class);
    private final Map<Class<? extends IJsonNode>, Class<? extends IJsonNode>> interfaceImplementations = new IdentityHashMap<Class<? extends IJsonNode>, Class<? extends IJsonNode>>();

    @Override
    public <T extends IJsonNode> T instantiate(Class<T> interfaceType) {
        Class<? extends IJsonNode> defaultImplementation = this.interfaceImplementations.get(interfaceType);
        if (defaultImplementation != null) {
            return (T)((IJsonNode)ReflectUtil.newInstance(defaultImplementation));
        }
        if (interfaceType == NullNode.class) {
            return (T)NullNode.getInstance();
        }
        if (interfaceType == MissingNode.class) {
            return (T)MissingNode.getInstance();
        }
        return (T)((IJsonNode)ReflectUtil.newInstance(interfaceType));
    }

    public <T extends IJsonNode> DefaultNodeFactory register(Class<T> interfaceType, Class<? extends T> implementationType) {
        this.interfaceImplementations.put(interfaceType, implementationType);
        return this;
    }

    public static DefaultNodeFactory getInstance() {
        return Instance;
    }
}

