/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import eu.stratosphere.sopremo.type.AbstractNumericNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.INumericNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalNode
extends AbstractNumericNode
implements INumericNode {
    private BigDecimal value;

    public DecimalNode() {
        this.value = new BigDecimal(0);
    }

    public DecimalNode(BigDecimal v) {
        this.value = v;
    }

    public DecimalNode(String textual) {
        this.value = new BigDecimal(textual);
    }

    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append(this.value.toPlainString());
    }

    @Override
    public void clear() {
        this.value = BigDecimal.ZERO;
    }

    @Override
    public int compareToSameType(IJsonNode other) {
        return this.value.compareTo(((DecimalNode)other).value);
    }

    @Override
    public void copyValueFrom(IJsonNode otherNode) {
        DecimalNode.checkNumber(otherNode);
        this.value = ((INumericNode)otherNode).getDecimalValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DecimalNode other = (DecimalNode)obj;
        return this.value.equals(other.value);
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.value.toBigInteger();
    }

    @Override
    public BigDecimal getDecimalValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public byte getGeneralilty() {
        return 80;
    }

    @Override
    public int getIntValue() {
        return this.value.intValue();
    }

    @Override
    public BigDecimal getJavaValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value.longValue();
    }

    public Class<DecimalNode> getType() {
        return DecimalNode.class;
    }

    @Override
    public String getValueAsText() {
        return this.value.toPlainString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value.hashCode();
        return result;
    }

    @Override
    public boolean isFloatingPointNumber() {
        return true;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public static DecimalNode valueOf(BigDecimal v) {
        if (v == null) {
            throw new NullPointerException();
        }
        return new DecimalNode(v);
    }
}

