/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import eu.stratosphere.sopremo.type.AbstractArrayNode;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.util.CachingList;
import java.lang.reflect.Array;

@DefaultSerializer(value=AbstractArrayNode.ArraySerializer.class)
public class CachingArrayNode<T extends IJsonNode>
extends ArrayNode<T> {
    public CachingArrayNode() {
        this(IJsonNode.class);
    }

    public CachingArrayNode(CachingList<T> objectArrayList) {
        super(objectArrayList);
    }

    public CachingArrayNode(Class<T> elemType) {
        this(CachingList.wrap((Object[])((IJsonNode[])Array.newInstance(elemType, 0))));
    }

    public CachingArrayNode<T> addClone(T node) {
        T unusedNode = this.reuseUnusedNode();
        if (unusedNode == null) {
            this.add(node.clone());
        } else if (unusedNode.getType() == node.getType()) {
            unusedNode.copyValueFrom((IJsonNode)node);
        } else {
            this.set(this.size() - 1, node.clone());
        }
        return this;
    }

    @Override
    public void clear() {
        for (IJsonNode element : this) {
            element.clear();
        }
        super.clear();
    }

    @Override
    public AbstractArrayNode<T> copy(Kryo kryo) {
        CachingArrayNode<T> node = new CachingArrayNode<T>();
        node.copyValueFrom(this);
        return node;
    }

    public T getUnusedNode() {
        return (T)((IJsonNode)((CachingList)this.getChildren()).getUnusedElement());
    }

    public T reuseUnusedNode() {
        return (T)((IJsonNode)((CachingList)this.getChildren()).reuseUnusedElement());
    }

    public void setAll(T[] nodes) {
        for (int index = 0; index < nodes.length; ++index) {
            this.set(index, nodes[index]);
        }
        this.setSize(nodes.length);
    }

    @Override
    public void setSize(int size) {
        ((CachingList)this.getChildren()).size(size, (Object)MissingNode.getInstance());
    }
}

