/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import eu.stratosphere.sopremo.type.AbstractJsonNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IPrimitiveNode;
import java.io.IOException;
import javolution.text.TypeFormat;

public class BooleanNode
extends AbstractJsonNode
implements IPrimitiveNode {
    public static final BooleanNode TRUE = new UnmodifiableBoolean(true);
    public static final BooleanNode FALSE = new UnmodifiableBoolean(false);
    private boolean value;

    public BooleanNode() {
        this(false);
    }

    private BooleanNode(boolean v) {
        this.value = v;
    }

    public void appendAsString(Appendable appendable) throws IOException {
        TypeFormat.format((boolean)this.value, (Appendable)appendable);
    }

    @Override
    public void clear() {
    }

    @Override
    public BooleanNode clone() {
        return (BooleanNode)super.clone();
    }

    @Override
    public int compareToSameType(IJsonNode other) {
        return (this.value ? 1 : 0) - (((BooleanNode)other).value ? 1 : 0);
    }

    @Override
    public void copyValueFrom(IJsonNode otherNode) {
        this.checkForSameType(otherNode);
        this.value = ((BooleanNode)otherNode).value;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanNode)) {
            return false;
        }
        BooleanNode other = (BooleanNode)obj;
        return this.value == other.value;
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    public Class<BooleanNode> getType() {
        return BooleanNode.class;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value ? 1231 : 1237);
        return result;
    }

    public BooleanNode negate() {
        return this.value ? FALSE : TRUE;
    }

    public static BooleanNode valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    @DefaultSerializer(value=BooleanSerializer.class)
    private static final class UnmodifiableBoolean
    extends BooleanNode {
        private UnmodifiableBoolean(boolean v) {
            super(v);
        }

        @Override
        public UnmodifiableBoolean clone() {
            return this;
        }

        @Override
        public void copyValueFrom(IJsonNode otherNode) {
            throw new UnsupportedOperationException();
        }

        public static class BooleanSerializer
        extends Serializer<UnmodifiableBoolean> {
            public BooleanSerializer() {
                this.setImmutable(true);
            }

            public UnmodifiableBoolean read(Kryo kryo, Input input, Class<UnmodifiableBoolean> type) {
                return (UnmodifiableBoolean)BooleanNode.valueOf(input.readBoolean());
            }

            public void write(Kryo kryo, Output output, UnmodifiableBoolean object) {
                output.writeBoolean(object == TRUE);
            }
        }
    }
}

