/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import eu.stratosphere.sopremo.type.AbstractNumericNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.INumericNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javolution.text.TextFormat;

public class BigIntegerNode
extends AbstractNumericNode
implements INumericNode {
    private BigInteger value;

    public BigIntegerNode() {
        this.value = BigInteger.ZERO;
    }

    public BigIntegerNode(BigInteger v) {
        this.value = v;
    }

    public void appendAsString(Appendable appendable) throws IOException {
        TextFormat.getInstance(BigInteger.class).format((Object)this.value, appendable);
    }

    @Override
    public void clear() {
        this.value = BigInteger.ZERO;
    }

    @Override
    public int compareToSameType(IJsonNode other) {
        return this.value.compareTo(((BigIntegerNode)other).value);
    }

    @Override
    public void copyValueFrom(IJsonNode otherNode) {
        BigIntegerNode.checkNumber(otherNode);
        this.value = ((INumericNode)otherNode).getBigIntegerValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerNode other = (BigIntegerNode)obj;
        return this.value.equals(other.value);
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.value;
    }

    @Override
    public BigDecimal getDecimalValue() {
        return new BigDecimal(this.value);
    }

    @Override
    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public byte getGeneralilty() {
        return 48;
    }

    @Override
    public int getIntValue() {
        return this.value.intValue();
    }

    @Override
    public BigInteger getJavaValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value.longValue();
    }

    public Class<BigIntegerNode> getType() {
        return BigIntegerNode.class;
    }

    @Override
    public String getValueAsText() {
        return this.value.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value.hashCode();
        return result;
    }

    @Override
    public boolean isIntegralNumber() {
        return true;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public static BigIntegerNode valueOf(BigInteger bigInteger) {
        if (bigInteger != null) {
            return new BigIntegerNode(bigInteger);
        }
        throw new NullPointerException();
    }
}

