/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.google.common.collect.Iterators;
import eu.stratosphere.sopremo.type.AbstractArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IStreamNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.util.CollectionUtil;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@DefaultSerializer(value=AbstractArrayNode.ArraySerializer.class)
public class ArrayNode<T extends IJsonNode>
extends AbstractArrayNode<T> {
    private final ObjectArrayList<T> children;
    public static final IArrayNode<?> EMPTY = new ArrayNode(Collections.EMPTY_LIST);

    public ArrayNode() {
        this(IJsonNode.class, 0);
    }

    public ArrayNode(int size) {
        this(new ArrayList(size));
        for (int index = 0; index < size; ++index) {
            this.add(MissingNode.getInstance());
        }
    }

    public ArrayNode(Iterable<? extends T> nodes) {
        this();
        for (IJsonNode node : nodes) {
            if (node == null) {
                throw new NullPointerException();
            }
            this.children.add((Object)node);
        }
    }

    public ArrayNode(T ... nodes) {
        this(nodes.getClass().getComponentType(), nodes.length);
        for (int index = 0; index < nodes.length; ++index) {
            T node = nodes[index];
            if (node == null) {
                throw new NullPointerException();
            }
            this.children.set(index, node);
        }
    }

    protected ArrayNode(Class<T> elemType, int size) {
        this(ObjectArrayList.wrap((Object[])((IJsonNode[])Array.newInstance(elemType, size))));
    }

    protected ArrayNode(ObjectArrayList<T> children) {
        this.children = children;
    }

    @Override
    public ArrayNode<T> add(int index, T element) {
        if (element == null) {
            throw new NullPointerException();
        }
        this.children.add(index, element);
        return this;
    }

    @Override
    public ArrayNode<T> add(T node) {
        if (node == null) {
            throw new NullPointerException();
        }
        this.children.add(node);
        return this;
    }

    @Override
    public List<T> asList() {
        return this.children;
    }

    @Override
    public void clear() {
        this.children.clear();
    }

    @Override
    public ArrayNode<T> clone() {
        return (ArrayNode)super.clone();
    }

    @Override
    public int compareToSameType(IJsonNode other) {
        IArrayNode node = (IArrayNode)other;
        if (node.size() != this.size()) {
            return this.size() - node.size();
        }
        for (int i = 0; i < this.size(); ++i) {
            int comp = this.get(i).compareTo((IJsonNode)node.get(i));
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    @Override
    public boolean contains(IJsonNode node) {
        return this.children.contains((Object)node);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return super.equals(obj);
        }
        ArrayNode other = (ArrayNode)obj;
        int size = this.size();
        if (other.size() != size) {
            return false;
        }
        for (int index = 0; index < size; ++index) {
            if (((IJsonNode)this.children.get(index)).equals(other.children.get(index))) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        if (0 <= index && index < this.children.size()) {
            return (T)((IJsonNode)this.children.get(index));
        }
        return (T)MissingNode.getInstance();
    }

    public T[] getBackingArray() {
        return (IJsonNode[])this.children.elements();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.limit((Iterator)this.children.iterator(), (int)this.size());
    }

    @Override
    public void remove(int index) {
        if (0 <= index && index < this.children.size()) {
            this.children.remove(index);
        }
    }

    @Override
    public void set(int index, T node) {
        if (node == null) {
            throw new NullPointerException();
        }
        CollectionUtil.ensureSize(this.children, (int)(index + 1), (Object)MissingNode.getInstance());
        this.children.set(index, node);
    }

    @Override
    public int size() {
        int size;
        for (size = this.children.size(); size > 0 && this.children.get(size - 1) == MissingNode.getInstance(); --size) {
        }
        return size;
    }

    public IJsonNode subArray(int fromIndex, int toIndex) {
        return new ArrayNode<T>(this.children.subList(fromIndex, toIndex));
    }

    @Override
    protected void fillArray(IJsonNode[] result) {
        IJsonNode[] array = (IJsonNode[])this.children.toArray((Object[])new IJsonNode[this.children.size()]);
        for (int i = 0; i < this.children.size(); ++i) {
            result[i] = array[i];
        }
    }

    protected AbstractObjectList<T> getChildren() {
        return this.children;
    }

    public static <T extends IJsonNode> ArrayNode<T> deepClone(Class<T> elemType, IStreamNode<? extends T> nodes) {
        ArrayNode<T> clone = new ArrayNode<T>(elemType, 0);
        for (IJsonNode iJsonNode : nodes) {
            clone.children.add((Object)iJsonNode.clone());
        }
        return clone;
    }

    public static <T extends IJsonNode> ArrayNode<T> deepClone(IStreamNode<? extends T> nodes) {
        ArrayNode<T> clone = new ArrayNode<T>();
        for (IJsonNode iJsonNode : nodes) {
            clone.children.add((Object)iJsonNode.clone());
        }
        return clone;
    }

    public static <T extends IJsonNode> ArrayNode<T> valueOf(Iterator<T> iterator) {
        ArrayNode<T> array = new ArrayNode<T>();
        while (iterator.hasNext()) {
            array.add((IJsonNode)iterator.next());
        }
        return array;
    }
}

