/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import com.google.common.reflect.TypeToken;
import eu.stratosphere.util.Reference;
import eu.stratosphere.util.reflect.TypeHierarchyBrowser;
import eu.stratosphere.util.reflect.Visitor;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTypeMapper<M> {
    private final Map<Type, Map<Type, M>> mappers = new IdentityHashMap<Type, Map<Type, M>>();
    private final Map<Type, Type> defaultTypeMappings = new IdentityHashMap<Type, Type>();

    public Type getDefaultMappingType(Class<?> fromClass) {
        Type type = this.defaultTypeMappings.get(fromClass);
        if (type != null) {
            return type;
        }
        return this.findDefaultMappingType(fromClass);
    }

    public Type getDefaultMappingType(Type javaType) {
        Type type = this.defaultTypeMappings.get(javaType);
        if (type != null) {
            return type;
        }
        return this.findDefaultMappingType(javaType);
    }

    public M getMapper(Class<? extends Object> fromClass, Type targetType) {
        M targetMapper;
        Class rawTarget = TypeToken.of((Type)targetType).getRawType();
        Map<Type, M> fromMappers = this.mappers.get(fromClass);
        if (fromMappers != null && (targetMapper = fromMappers.get(targetType)) != null) {
            return targetMapper;
        }
        targetMapper = this.findMapperRecursively(fromClass, targetType, rawTarget);
        this.addMapper(fromClass, rawTarget, targetMapper);
        return targetMapper;
    }

    protected void addDefaultTypeMapping(Type from, Type to) {
        this.defaultTypeMappings.put(from, to);
    }

    protected void addMapper(Type from, Type target, M mapper) {
        Map<Type, M> fromMappers = this.mappers.get(from);
        if (fromMappers == null) {
            fromMappers = new IdentityHashMap<Type, M>();
            this.mappers.put(from, fromMappers);
        }
        fromMappers.put(target, mapper);
    }

    protected Type findDefaultMappingType(Class<?> fromClass) {
        Type superClass = AbstractTypeMapper.findRegisteredSuperclass(this.defaultTypeMappings.keySet(), fromClass);
        if (superClass != null) {
            Type type = this.defaultTypeMappings.get(superClass);
            this.defaultTypeMappings.put(fromClass, type);
            return type;
        }
        return null;
    }

    protected Type findDefaultMappingType(Type javaType) {
        if (!(javaType instanceof Class)) {
            Class rawType = TypeToken.of((Type)javaType).getRawType();
            Type rawJsonType = this.getDefaultMappingType(rawType);
            this.defaultTypeMappings.put(javaType, rawJsonType);
            return rawJsonType;
        }
        return this.findDefaultMappingType((Class)javaType);
    }

    protected M findMapper(Class<?> fromClass, Class<?> originalFromClass, Type targetType, Class<?> rawTarget) {
        Map<Type, M> fromMappers = this.mappers.get(fromClass);
        if (fromMappers == null) {
            return null;
        }
        M targetMapper = fromMappers.get(rawTarget);
        if (targetMapper == null) {
            Class rawDefaultType;
            Type defaultType = this.getDefaultMappingType(originalFromClass);
            Class clazz = rawDefaultType = defaultType == null ? null : TypeToken.of((Type)defaultType).getRawType();
            if (rawDefaultType != null && rawDefaultType != rawTarget && rawTarget.isAssignableFrom(rawDefaultType)) {
                targetMapper = this.findMapperRecursively(originalFromClass, targetType, rawDefaultType);
            } else {
                Type targetSuperClass = AbstractTypeMapper.findRegisteredSubclass(fromMappers.keySet(), rawTarget);
                if (targetSuperClass != null) {
                    targetMapper = fromMappers.get(targetSuperClass);
                }
            }
        }
        return targetMapper;
    }

    private M findMapperRecursively(final Class<? extends Object> fromClass, final Type targetType, final Class<?> rawTarget) {
        M targetMapper = this.findMapper(fromClass, fromClass, targetType, rawTarget);
        if (targetMapper != null) {
            return targetMapper;
        }
        final Reference foundMapper = new Reference();
        TypeHierarchyBrowser.INSTANCE.visit(fromClass, TypeHierarchyBrowser.Mode.CLASS_FIRST, new Visitor<Class<?>>(){

            public boolean visited(Class<?> superClass, int distance) {
                Object mapper = AbstractTypeMapper.this.findMapper(superClass, fromClass, targetType, rawTarget);
                if (mapper == null) {
                    return true;
                }
                foundMapper.setValue(mapper);
                return false;
            }
        });
        return (M)foundMapper.getValue();
    }

    protected static Type findRegisteredSubclass(Set<? extends Type> map, Class<?> targetType) {
        TypeToken token = TypeToken.of(targetType);
        for (Type type : map) {
            if (!token.isAssignableFrom(type)) continue;
            return type;
        }
        return null;
    }

    protected static Type findRegisteredSuperclass(Set<? extends Type> map, Class<?> targetType) {
        for (Type type : map) {
            if (!TypeToken.of((Type)type).isAssignableFrom(targetType)) continue;
            return type;
        }
        return null;
    }
}

