/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.type.IJsonNode;

public abstract class AbstractJsonNode
extends AbstractSopremoType
implements IJsonNode {
    @Override
    public AbstractJsonNode clone() {
        return (AbstractJsonNode)super.clone();
    }

    @Override
    public int compareTo(IJsonNode otherNode) {
        int result = this.getType() != otherNode.getType() ? this.compareToOtherType(otherNode) : this.compareToSameType(otherNode);
        return result;
    }

    @Override
    public abstract int compareToSameType(IJsonNode var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IJsonNode)) {
            return false;
        }
        IJsonNode other = (IJsonNode)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        return this.compareToSameType(other) == 0;
    }

    public abstract int hashCode();

    protected void checkForSameType(IJsonNode other) {
        if (other.getType() != this.getType()) {
            throw new IllegalArgumentException(String.format("The type of this node %s does not match the type of the other node %s: %s", this.getType(), other.getType(), other));
        }
    }

    protected int compareToOtherType(IJsonNode other) {
        return this.getType().getName().compareTo(other.getType().getName());
    }
}

