/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.type;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoCopyable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import eu.stratosphere.sopremo.cache.ArrayCache;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.type.AbstractJsonNode;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.ReusingSerializer;
import eu.stratosphere.util.AppendUtil;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@DefaultSerializer(value=ArraySerializer.class)
public abstract class AbstractArrayNode<T extends IJsonNode>
extends AbstractJsonNode
implements IArrayNode<T>,
KryoCopyable<AbstractArrayNode<T>> {
    @Override
    public IArrayNode<T> addAll(Iterable<? extends T> it) {
        for (IJsonNode jsonNode : it) {
            this.add(jsonNode);
        }
        return this;
    }

    @Override
    public IArrayNode<T> addAll(T[] nodes) {
        this.addAll(Arrays.asList(nodes));
        return this;
    }

    public void appendAsString(Appendable appendable) throws IOException {
        AppendUtil.append((Appendable)appendable, (Iterable)this);
    }

    public List<T> asList() {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return AbstractArrayNode.this.get(index);
            }

            @Override
            public Iterator<T> iterator() {
                return this.iterator();
            }

            @Override
            public int size() {
                return AbstractArrayNode.this.size();
            }
        };
    }

    @Override
    public AbstractArrayNode<T> clone() {
        return (AbstractArrayNode)super.clone();
    }

    @Override
    public int compareToSameType(IJsonNode other) {
        IArrayNode node = (IArrayNode)other;
        Iterator entries1 = this.iterator();
        Iterator entries2 = node.iterator();
        while (entries1.hasNext() && entries2.hasNext()) {
            IJsonNode entry2;
            IJsonNode entry1 = (IJsonNode)entries1.next();
            int comparison = entry1.compareTo(entry2 = (IJsonNode)entries2.next());
            if (comparison == 0) continue;
            return comparison;
        }
        if (entries1.hasNext()) {
            return 1;
        }
        if (entries2.hasNext()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean contains(T node) {
        for (IJsonNode element : this) {
            if (!node.equals(element)) continue;
            return true;
        }
        return false;
    }

    public AbstractArrayNode<T> copy(Kryo kryo) {
        ArrayNode node = new ArrayNode();
        node.copyValueFrom(this);
        return node;
    }

    @Override
    public void copyValueFrom(IJsonNode otherNode) {
        int index;
        this.checkForSameType(otherNode);
        IArrayNode array = (IArrayNode)otherNode;
        int length = Math.max(this.size(), array.size());
        for (index = 0; index < length; ++index) {
            IJsonNode existingNode = this.get(index);
            Object newNode = array.get(index);
            if (existingNode.getType() == newNode.getType()) {
                existingNode.copyValueFrom((IJsonNode)newNode);
                continue;
            }
            this.set(index, newNode.clone());
        }
        length = array.size();
        while (index < length) {
            this.add(array.get(0).clone());
            ++index;
        }
        for (length = this.size(); index < length; --length) {
            this.remove(index);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IArrayNode)) {
            return false;
        }
        Iterator thisIter = this.iterator();
        Iterator thatIter = ((IArrayNode)obj).iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            if (((IJsonNode)thisIter.next()).equals(thatIter.next())) continue;
            return false;
        }
        return thisIter.hasNext() == thatIter.hasNext();
    }

    public Class<IArrayNode<T>> getType() {
        return IArrayNode.class;
    }

    @Override
    public int hashCode() {
        int prime = 41;
        int hashCode = 41;
        for (IJsonNode node : this) {
            hashCode = (hashCode + node.hashCode()) * 41;
        }
        return 41;
    }

    public void setSize(int len) {
        int size = this.size();
        for (int i = len; i < size; ++i) {
            this.set(i, MissingNode.getInstance());
        }
    }

    @Override
    public T[] toArray(ArrayCache<T> arrayCache) {
        IJsonNode[] result = (IJsonNode[])arrayCache.getArray(this.size());
        this.fillArray(result);
        return result;
    }

    protected void fillArray(IJsonNode[] result) {
        int i = 0;
        for (IJsonNode node : this) {
            result[i++] = node;
        }
    }

    public static final class ArraySerializer
    extends ReusingSerializer<AbstractArrayNode<?>> {
        @Override
        public AbstractArrayNode<?> read(Kryo kryo, Input input, AbstractArrayNode<?> oldInstance, Class<AbstractArrayNode<?>> type) {
            if (oldInstance == null) {
                return this.read(kryo, input, (Class)type);
            }
            int len = input.readInt();
            ArrayNode array = (ArrayNode)oldInstance;
            for (int i = 0; i < len; ++i) {
                array.set(i, (IJsonNode)SopremoUtil.deserializeInto(kryo, input, array.get(i)));
            }
            array.setSize(len);
            return array;
        }

        @Override
        public AbstractArrayNode<?> read(Kryo kryo, Input input, Class<AbstractArrayNode<?>> type) {
            int len = input.readInt();
            AbstractArrayNode array = (AbstractArrayNode)kryo.newInstance(type);
            for (int i = 0; i < len; ++i) {
                array.add((IJsonNode)kryo.readClassAndObject(input));
            }
            return array;
        }

        public void write(Kryo kryo, Output output, AbstractArrayNode<?> array) {
            output.writeInt(array.size());
            for (IJsonNode entry : array) {
                kryo.writeClassAndObject(output, (Object)entry);
            }
        }
    }
}

