/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.tokenizer;

import eu.stratosphere.sopremo.tokenizer.AbstractTokenizer;
import eu.stratosphere.sopremo.tokenizer.Tokenizer;
import eu.stratosphere.sopremo.type.CachingArrayNode;
import eu.stratosphere.sopremo.type.TextNode;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javolution.text.TextFormat;

public class DelimiterTokenizer
extends AbstractTokenizer
implements Tokenizer {
    private final CharSet delimiters = new CharOpenHashSet();
    public static final DelimiterTokenizer WHITESPACES = new DelimiterTokenizer(Character.valueOf(' '), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\t'));

    public DelimiterTokenizer() {
    }

    public DelimiterTokenizer(Character ... delimiters) {
        this(Arrays.asList(delimiters));
    }

    public DelimiterTokenizer(Collection<Character> delimiters) {
        this.delimiters.addAll(delimiters);
    }

    public DelimiterTokenizer addDelimiter(char delimiter) {
        this.delimiters.add(delimiter);
        return this;
    }

    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("DelimiterTokenizer [");
        appendable.append("delimiters=");
        TextFormat.getInstance(CharSet.class).format((Object)this.delimiters, appendable);
        appendable.append("]");
    }

    public void setDelimiters(Collection<Character> delimiters) {
        if (delimiters == null) {
            throw new NullPointerException("delimiters must not be null");
        }
        this.delimiters.clear();
        this.delimiters.addAll(delimiters);
    }

    @Override
    public void tokenizeInto(CharSequence text, CachingArrayNode<TextNode> tokens) {
        int textIndex;
        tokens.setSize(0);
        int tokenStart = 0;
        for (textIndex = 0; textIndex < text.length(); ++textIndex) {
            char ch = text.charAt(textIndex);
            if (!this.delimiters.contains(ch)) continue;
            if (textIndex == tokenStart) {
                ++tokenStart;
                continue;
            }
            this.addToken(tokens, text, tokenStart, textIndex);
            tokenStart = textIndex + 1;
        }
        if (textIndex != tokenStart) {
            this.addToken(tokens, text, tokenStart, textIndex);
        }
    }
}

