/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.serialization;

import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.api.common.typeutils.TypeSerializerFactory;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.serialization.SopremoRecord;
import eu.stratosphere.sopremo.serialization.SopremoRecordLayout;
import eu.stratosphere.sopremo.serialization.SopremoRecordSerializer;

public class SopremoRecordSerializerFactory
implements TypeSerializerFactory<SopremoRecord> {
    private SopremoRecordLayout layout;

    public SopremoRecordSerializerFactory() {
    }

    public SopremoRecordSerializerFactory(SopremoRecordLayout layout) {
        if (layout == null) {
            throw new NullPointerException();
        }
        this.layout = layout;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SopremoRecordSerializerFactory other = (SopremoRecordSerializerFactory)obj;
        return this.layout.equals(other.layout);
    }

    public Class<SopremoRecord> getDataType() {
        return SopremoRecord.class;
    }

    public TypeSerializer<SopremoRecord> getSerializer() {
        return new SopremoRecordSerializer(this.layout);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.layout.hashCode();
        return result;
    }

    public void readParametersFromConfig(Configuration config, ClassLoader cl) throws ClassNotFoundException {
        this.layout = SopremoUtil.getObject(config, "sopremo.layout", null);
    }

    public void writeParametersToConfig(Configuration config) {
        SopremoUtil.setObject(config, "sopremo.layout", this.layout);
    }
}

