/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.serialization;

import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.sopremo.serialization.SopremoRecord;
import eu.stratosphere.sopremo.serialization.SopremoRecordLayout;
import java.io.IOException;

public class SopremoRecordSerializer
extends TypeSerializer<SopremoRecord> {
    private final SopremoRecordLayout layout;

    SopremoRecordSerializer(SopremoRecordLayout layout) {
        if (layout == null) {
            throw new NullPointerException();
        }
        this.layout = layout;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int numKeys = this.layout.getNumKeys();
        for (int index = 0; index < numKeys; ++index) {
            target.writeInt(source.readInt());
        }
        int size = source.readInt();
        target.writeInt(size);
        target.write(source, size);
    }

    public void copyTo(SopremoRecord from, SopremoRecord to) {
        from.copyTo(to);
    }

    public SopremoRecord createCopy(SopremoRecord from) {
        return (SopremoRecord)from.copy();
    }

    public SopremoRecord createInstance() {
        return new SopremoRecord();
    }

    public void deserialize(SopremoRecord target, DataInputView source) throws IOException {
        target.read(source, this.layout);
        target.getOrParseNode();
    }

    public int getLength() {
        return -1;
    }

    public void serialize(SopremoRecord record, DataOutputView target) throws IOException {
        record.write(target, this.layout);
    }
}

