/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.serialization;

import eu.stratosphere.api.common.typeutils.TypePairComparator;
import eu.stratosphere.sopremo.cache.NodeCache;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.serialization.CachingNodeFactory;
import eu.stratosphere.sopremo.serialization.SopremoRecord;
import eu.stratosphere.sopremo.type.IJsonNode;

public class SopremoRecordPairComparator
extends TypePairComparator<SopremoRecord, SopremoRecord> {
    private final int[] keyFields1;
    private final int[] keyFields2;
    private final EvaluationExpression[] keyExpressions1;
    private final EvaluationExpression[] keyExpressions2;
    private final IJsonNode[] keyHolders1;
    private final NodeCache[] nodeCache1;
    private final NodeCache[] nodeCache2;
    private final int numKeys;

    public SopremoRecordPairComparator(int[] keyFieldsReference, EvaluationExpression[] keyExpressions1, int[] keyFieldsCandidate, EvaluationExpression[] keyExpressions2) {
        this.numKeys = keyFieldsReference.length;
        if (this.numKeys != keyFieldsCandidate.length) {
            throw new IllegalArgumentException("The arrays describing the key expressions must be of the same length.");
        }
        this.keyFields1 = keyFieldsReference;
        this.keyFields2 = keyFieldsCandidate;
        this.keyExpressions1 = keyExpressions1;
        this.keyExpressions2 = keyExpressions2;
        this.keyHolders1 = new IJsonNode[this.numKeys];
        this.nodeCache1 = new NodeCache[this.numKeys];
        this.nodeCache2 = new NodeCache[this.numKeys];
        for (int index = 0; index < this.numKeys; ++index) {
            this.nodeCache1[index] = new NodeCache(CachingNodeFactory.getInstance());
            this.nodeCache2[index] = new NodeCache(CachingNodeFactory.getInstance());
        }
    }

    public int compareToReference(SopremoRecord candidate) {
        IJsonNode node = candidate.getNode();
        if (node == null) {
            for (int index = 0; index < this.numKeys; ++index) {
                IJsonNode k = candidate.getKey(this.keyFields2[index], this.nodeCache2[index]);
                int comparison = k.compareTo(this.keyHolders1[index]);
                if (comparison == 0) continue;
                return comparison;
            }
        } else {
            for (int index = 0; index < this.numKeys; ++index) {
                IJsonNode k = this.keyExpressions2[index].evaluate(node);
                int comparison = k.compareTo(this.keyHolders1[index]);
                if (comparison == 0) continue;
                return comparison;
            }
        }
        return 0;
    }

    public boolean equalToReference(SopremoRecord candidate) {
        IJsonNode node = candidate.getNode();
        if (node == null) {
            for (int index = 0; index < this.numKeys; ++index) {
                IJsonNode k = candidate.getKey(this.keyFields2[index], this.nodeCache2[index]);
                if (k.equals(this.keyHolders1[index])) continue;
                return false;
            }
        } else {
            for (int index = 0; index < this.numKeys; ++index) {
                IJsonNode k = this.keyExpressions2[index].evaluate(node);
                if (k.equals(this.keyHolders1[index])) continue;
                return false;
            }
        }
        return true;
    }

    public void setReference(SopremoRecord reference) {
        IJsonNode node = reference.getNode();
        if (node == null) {
            for (int index = 0; index < this.numKeys; ++index) {
                this.keyHolders1[index] = reference.getKey(this.keyFields1[index], this.nodeCache1[index]);
            }
        } else {
            for (int index = 0; index < this.numKeys; ++index) {
                this.keyHolders1[index] = SopremoUtil.copyInto(this.keyExpressions1[index].evaluate(node), this.nodeCache1[index]);
            }
        }
    }
}

