/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.serialization;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.expressions.ArrayAccess;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.serialization.ExpressionIndex;
import eu.stratosphere.util.AppendUtil;
import eu.stratosphere.util.IAppending;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

@DefaultSerializer(value=KryoSerializer.class)
public class SopremoRecordLayout
extends AbstractSopremoType {
    public static final int VALUE_INDEX = Integer.MAX_VALUE;
    public static final String LAYOUT_KEY = "sopremo.layout";
    public static final SopremoRecordLayout EMPTY = SopremoRecordLayout.create(new EvaluationExpression[0]);
    private static final int UNKNOWN_KEY_EXPRESSION = -1;
    private final transient Object2IntMap<EvaluationExpression> indexedDirectDataExpression = new Object2IntOpenHashMap();
    private final transient Object2IntMap<EvaluationExpression> indexedCalculatedKeyExpressions = new Object2IntOpenHashMap();
    private final EvaluationExpression[] directDataExpression;
    private final EvaluationExpression[] calculatedKeyExpressions;
    private final transient ExpressionIndex expressionIndex;

    public SopremoRecordLayout(ExpressionIndex expressionIndex, EvaluationExpression[] directDataExpression, EvaluationExpression[] calculatedKeyExpressions) {
        this.expressionIndex = expressionIndex;
        this.directDataExpression = directDataExpression;
        this.calculatedKeyExpressions = calculatedKeyExpressions;
        this.index(directDataExpression, calculatedKeyExpressions);
    }

    public void appendAsString(Appendable appendable) throws IOException {
        AppendUtil.append((Appendable)appendable, (IAppending[])this.directDataExpression);
        AppendUtil.append((Appendable)appendable, (IAppending[])this.calculatedKeyExpressions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SopremoRecordLayout other = (SopremoRecordLayout)obj;
        return Arrays.equals(this.directDataExpression, other.directDataExpression) && Arrays.equals(this.calculatedKeyExpressions, other.calculatedKeyExpressions);
    }

    public EvaluationExpression[] getCalculatedKeyExpressions() {
        return this.calculatedKeyExpressions;
    }

    public EvaluationExpression[] getDirectDataExpression() {
        return this.directDataExpression;
    }

    public EvaluationExpression getExpression(int expressionIndex) {
        if (expressionIndex == Integer.MAX_VALUE) {
            return EvaluationExpression.VALUE;
        }
        int numDirectDataKeys = this.getNumDirectDataKeys();
        if (expressionIndex < numDirectDataKeys) {
            return this.directDataExpression[expressionIndex];
        }
        return this.calculatedKeyExpressions[expressionIndex - numDirectDataKeys];
    }

    public ExpressionIndex getExpressionIndex() {
        return this.expressionIndex;
    }

    public int[] getIndices(EvaluationExpression ... keyExpressions) {
        int[] indices = new int[keyExpressions.length];
        for (int index = 0; index < indices.length; ++index) {
            indices[index] = this.getKeyIndex(keyExpressions[index]);
        }
        return indices;
    }

    public List<EvaluationExpression> getKeyExpressions() {
        return Lists.newArrayList((Iterable)Iterables.concat(Arrays.asList(this.directDataExpression), Arrays.asList(this.calculatedKeyExpressions)));
    }

    public int getKeyIndex(EvaluationExpression expression) {
        if (expression == EvaluationExpression.VALUE) {
            return -1;
        }
        int offset = this.indexedDirectDataExpression.getInt((Object)expression);
        if (offset == -1) {
            offset = this.indexedCalculatedKeyExpressions.getInt((Object)expression);
        }
        if (offset == -1) {
            throw new IllegalArgumentException(String.format("Unknown key expression %s; registered expressions: %s", expression, this.getKeyExpressions()));
        }
        return offset;
    }

    public int getNumDirectDataKeys() {
        return this.directDataExpression.length;
    }

    public int getNumKeys() {
        return this.directDataExpression.length + this.calculatedKeyExpressions.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.calculatedKeyExpressions);
        result = 31 * result + Arrays.hashCode(this.directDataExpression);
        return result;
    }

    public IntCollection indicesOf(EvaluationExpression expression) {
        IntArrayList indices = new IntArrayList();
        if (expression == EvaluationExpression.VALUE) {
            indices.add(Integer.MAX_VALUE);
        } else if (expression instanceof ArrayAccess && ((ArrayAccess)expression).isFixedSize()) {
            for (ArrayAccess arrayAccess : ((ArrayAccess)expression).decompose()) {
                indices.add(this.indexedDirectDataExpression.getInt((Object)arrayAccess));
            }
        } else {
            int index = this.indexedDirectDataExpression.getInt((Object)expression);
            if (index == -1) {
                index = this.getNumDirectDataKeys() + this.indexedCalculatedKeyExpressions.getInt((Object)expression);
            }
            indices.add(index);
        }
        return indices;
    }

    public SopremoRecordLayout project(BitSet keyIndices) {
        List<EvaluationExpression> keyExpressions = this.getKeyExpressions();
        ArrayList<EvaluationExpression> projectedExpressions = new ArrayList<EvaluationExpression>();
        int index = keyIndices.nextSetBit(0);
        while (index != -1) {
            projectedExpressions.add(keyExpressions.get(index));
            index = keyIndices.nextSetBit(index + 1);
        }
        return SopremoRecordLayout.create(projectedExpressions);
    }

    public SopremoRecordLayout project(int ... keyIndices) {
        List<EvaluationExpression> keyExpressions = this.getKeyExpressions();
        ArrayList<EvaluationExpression> projectedExpressions = new ArrayList<EvaluationExpression>();
        for (int index = 0; index < keyIndices.length; ++index) {
            projectedExpressions.add(keyExpressions.get(keyIndices[index]));
        }
        return SopremoRecordLayout.create(projectedExpressions);
    }

    private void index(EvaluationExpression[] directDataExpression, EvaluationExpression[] calculatedKeyExpressions) {
        int index;
        this.indexedDirectDataExpression.defaultReturnValue(-1);
        this.indexedCalculatedKeyExpressions.defaultReturnValue(-1);
        for (index = 0; index < directDataExpression.length; ++index) {
            this.indexedDirectDataExpression.put((Object)directDataExpression[index], index);
        }
        for (index = 0; index < calculatedKeyExpressions.length; ++index) {
            this.indexedCalculatedKeyExpressions.put((Object)calculatedKeyExpressions[index], index);
        }
    }

    public static SopremoRecordLayout create(EvaluationExpression keyExpressions) {
        return SopremoRecordLayout.create(Arrays.asList(keyExpressions));
    }

    public static SopremoRecordLayout create(EvaluationExpression ... keyExpressions) {
        return SopremoRecordLayout.create(Arrays.asList(keyExpressions));
    }

    public static SopremoRecordLayout create(Iterable<EvaluationExpression> keyExpressions) {
        ArrayList<EvaluationExpression> directDataExpression = new ArrayList<EvaluationExpression>();
        ArrayList<EvaluationExpression> calculatedKeyExpressions = new ArrayList<EvaluationExpression>();
        ExpressionIndex expressionIndex = new ExpressionIndex();
        for (EvaluationExpression keyExpression : keyExpressions) {
            if (keyExpression == EvaluationExpression.VALUE) continue;
            if (expressionIndex.add(keyExpression, directDataExpression.size())) {
                directDataExpression.add(keyExpression);
                continue;
            }
            calculatedKeyExpressions.add(keyExpression);
        }
        return new SopremoRecordLayout(expressionIndex, directDataExpression.toArray(new EvaluationExpression[directDataExpression.size()]), calculatedKeyExpressions.toArray(new EvaluationExpression[calculatedKeyExpressions.size()]));
    }

    public static class KryoSerializer
    extends Serializer<SopremoRecordLayout> {
        public SopremoRecordLayout copy(Kryo kryo, SopremoRecordLayout original) {
            return original;
        }

        public SopremoRecordLayout read(Kryo kryo, Input input, Class<SopremoRecordLayout> type) {
            return SopremoRecordLayout.create((Iterable)kryo.readObject(input, ArrayList.class));
        }

        public void write(Kryo kryo, Output output, SopremoRecordLayout object) {
            kryo.writeObject(output, object.getKeyExpressions());
        }
    }
}

