/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.serialization;

import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.api.common.typeutils.TypeComparatorFactory;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.serialization.SopremoRecord;
import eu.stratosphere.sopremo.serialization.SopremoRecordComparator;
import eu.stratosphere.sopremo.serialization.SopremoRecordLayout;
import java.util.Arrays;

public class SopremoRecordComparatorFactory
implements TypeComparatorFactory<SopremoRecord> {
    public static final String DIRECTION = "sopremo.direction";
    public static final String KEYS = "sopremo.keys";
    private SopremoRecordLayout layout;
    private int[] keyExpressions;
    private boolean[] ascending;

    public SopremoRecordComparatorFactory() {
    }

    public SopremoRecordComparatorFactory(SopremoRecordLayout layout, int[] keyExpressions, boolean[] ascending) {
        this.layout = layout;
        this.keyExpressions = keyExpressions;
        this.ascending = ascending;
    }

    public TypeComparator<SopremoRecord> createComparator() {
        return new SopremoRecordComparator(this.layout, this.keyExpressions, this.ascending);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SopremoRecordComparatorFactory other = (SopremoRecordComparatorFactory)obj;
        return Arrays.equals(this.ascending, other.ascending) && Arrays.equals(this.keyExpressions, other.keyExpressions) && this.layout.equals(other.layout);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.ascending);
        result = 31 * result + Arrays.hashCode(this.keyExpressions);
        result = 31 * result + this.layout.hashCode();
        return result;
    }

    public void readParametersFromConfig(Configuration config, ClassLoader cl) throws ClassNotFoundException {
        this.ascending = SopremoUtil.getObject(config, DIRECTION, null);
        this.keyExpressions = SopremoUtil.getObject(config, KEYS, null);
        this.layout = SopremoUtil.getObject(config, "sopremo.layout", null);
    }

    public void writeParametersToConfig(Configuration config) {
        SopremoUtil.setObject(config, "sopremo.layout", this.layout);
        SopremoUtil.setObject(config, KEYS, this.keyExpressions);
        SopremoUtil.setObject(config, DIRECTION, this.ascending);
    }
}

