/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.serialization;

import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.sopremo.cache.NodeCache;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.serialization.CachingNodeFactory;
import eu.stratosphere.sopremo.serialization.SopremoRecord;
import eu.stratosphere.sopremo.serialization.SopremoRecordLayout;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;

public final class SopremoRecordComparator
extends TypeComparator<SopremoRecord> {
    private SopremoRecord reference;
    private final int[] keyExpressionIndices;
    private final NodeCache[] nodeCache1;
    private final NodeCache[] nodeCache2;
    private final IJsonNode[] keys;
    private final SopremoRecord temp1;
    private final SopremoRecord temp2;
    private final boolean[] ascending;
    private final SopremoRecordLayout layout;
    private final EvaluationExpression[] keyExpressions;

    public SopremoRecordComparator(SopremoRecordLayout layout, int[] keyExpressionIndices, boolean[] ascending) {
        this.layout = layout;
        this.keyExpressionIndices = keyExpressionIndices;
        this.keyExpressions = new EvaluationExpression[keyExpressionIndices.length];
        this.keys = new IJsonNode[this.keyExpressionIndices.length];
        this.nodeCache1 = new NodeCache[this.keyExpressionIndices.length];
        this.nodeCache2 = new NodeCache[this.keyExpressionIndices.length];
        for (int index = 0; index < this.keyExpressionIndices.length; ++index) {
            this.nodeCache1[index] = new NodeCache(CachingNodeFactory.getInstance());
            this.nodeCache2[index] = new NodeCache(CachingNodeFactory.getInstance());
            this.keyExpressions[index] = layout.getExpression(this.keyExpressionIndices[index]);
        }
        this.temp1 = new SopremoRecord();
        this.temp2 = new SopremoRecord();
        this.ascending = ascending;
    }

    public int compare(DataInputView firstSource, DataInputView secondSource) throws IOException {
        this.temp1.read(firstSource, this.layout);
        this.temp2.read(secondSource, this.layout);
        for (int index = 0; index < this.keyExpressionIndices.length; ++index) {
            IJsonNode k2;
            IJsonNode k1 = this.temp1.getKey(this.keyExpressionIndices[index], this.nodeCache1[index]);
            int comparison = k1.compareTo(k2 = this.temp2.getKey(this.keyExpressionIndices[index], this.nodeCache2[index]));
            if (comparison == 0) continue;
            return this.ascending[index] ? comparison : -comparison;
        }
        return 0;
    }

    public int compareToReference(TypeComparator<SopremoRecord> referencedComparator) {
        SopremoRecordComparator other = (SopremoRecordComparator)referencedComparator;
        for (int index = 0; index < this.nodeCache1.length; ++index) {
            int comparison = this.keys[index].compareTo(other.keys[index]);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    public TypeComparator<SopremoRecord> duplicate() {
        return new SopremoRecordComparator(this.layout, this.keyExpressionIndices, this.ascending);
    }

    public boolean equalToReference(SopremoRecord candidate) {
        IJsonNode node = candidate.getNode();
        if (node == null) {
            for (int index = 0; index < this.keyExpressionIndices.length; ++index) {
                if (candidate.getKey(this.keyExpressionIndices[index], this.nodeCache2[index]).equals(this.keys[index])) continue;
                return false;
            }
        } else {
            for (int index = 0; index < this.keyExpressionIndices.length; ++index) {
                if (this.keyExpressions[index].evaluate(node).equals(this.keys[index])) continue;
                return false;
            }
        }
        return true;
    }

    public int[] getKeyExpressionIndices() {
        return this.keyExpressionIndices;
    }

    public EvaluationExpression[] getKeyExpressions() {
        return this.keyExpressions;
    }

    public SopremoRecordLayout getLayout() {
        return this.layout;
    }

    public int getNormalizeKeyLen() {
        return 0;
    }

    public int hash(SopremoRecord record) {
        int prime = 37;
        int hash = 37;
        IJsonNode node = record.getNode();
        if (node == null) {
            for (int index = 0; index < this.keyExpressionIndices.length; ++index) {
                hash = 37 * hash + record.getKey(this.keyExpressionIndices[index], this.nodeCache2[index]).hashCode();
            }
        } else {
            for (int index = 0; index < this.keyExpressionIndices.length; ++index) {
                hash = 37 * hash + this.keyExpressions[index].evaluate(node).hashCode();
            }
        }
        return hash;
    }

    public boolean invertNormalizedKey() {
        return false;
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return false;
    }

    public void putNormalizedKey(SopremoRecord record, MemorySegment target, int offset, int numBytes) {
    }

    public void readWithKeyDenormalization(SopremoRecord record, DataInputView source) throws IOException {
    }

    public void setReference(SopremoRecord toCompare) {
        this.reference = toCompare;
        IJsonNode node = toCompare.getNode();
        if (node == null) {
            for (int index = 0; index < this.keyExpressionIndices.length; ++index) {
                this.keys[index] = this.reference.getKey(this.keyExpressionIndices[index], this.nodeCache1[index]);
            }
        } else {
            for (int index = 0; index < this.keyExpressionIndices.length; ++index) {
                this.keys[index] = SopremoUtil.copyInto(this.keyExpressions[index].evaluate(node), this.nodeCache1[index]);
            }
        }
    }

    public boolean supportsNormalizedKey() {
        return false;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(SopremoRecord record, DataOutputView target) throws IOException {
    }
}

