/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.serialization;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.ISopremoType;
import eu.stratosphere.sopremo.SopremoEnvironment;
import eu.stratosphere.sopremo.cache.NodeCache;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.serialization.ExpressionIndex;
import eu.stratosphere.sopremo.serialization.SopremoRecordLayout;
import eu.stratosphere.sopremo.type.CachingArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.ObjectNode;
import eu.stratosphere.sopremo.type.ReusingSerializer;
import eu.stratosphere.sopremo.type.typed.TypedObjectNode;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.SortedSet;

@DefaultSerializer(value=SopremoRecordKryoSerializer.class)
public class SopremoRecord
extends AbstractSopremoType
implements ISopremoType {
    private static final int MISSING = -1;
    private final transient ByteArrayList binaryRepresentation = new ByteArrayList();
    private final transient Input input = new Input();
    private final transient Output output = new Output(new OutputStream(){

        @Override
        public void write(byte[] b) throws IOException {
            SopremoRecord.this.binaryRepresentation.addElements(SopremoRecord.this.binaryRepresentation.size(), b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            SopremoRecord.this.binaryRepresentation.addElements(SopremoRecord.this.binaryRepresentation.size(), b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            SopremoRecord.this.binaryRepresentation.add((byte)b);
        }
    });
    private transient IJsonNode node;
    private final transient Kryo kryo;
    private transient int[] offsets;
    private final transient Map<Class<? extends IJsonNode>, NodeSerializer<IJsonNode>> serializers = new IdentityHashMap<Class<? extends IJsonNode>, NodeSerializer<IJsonNode>>();
    private final transient Map<Class<? extends IJsonNode>, NodeDeserializer<IJsonNode>> deserializers = new IdentityHashMap<Class<? extends IJsonNode>, NodeDeserializer<IJsonNode>>();

    public SopremoRecord() {
        this.offsets = new int[0];
        this.kryo = SopremoEnvironment.getInstance().getEvaluationContext().getKryoForDataSerialization();
        this.serializers.put(IObjectNode.class, new ObjectSerializer());
        this.serializers.put(IArrayNode.class, new ArraySerializer());
        this.serializers.put(IJsonNode.class, new PrimitiveSerializer());
        this.deserializers.put(IObjectNode.class, new ObjectSerializer());
        this.deserializers.put(IArrayNode.class, new CachingArrayDeserializer());
        this.deserializers.put(IJsonNode.class, new PrimitiveSerializer());
    }

    public void appendAsString(Appendable appendable) throws IOException {
        this.getOrParseNode().appendAsString(appendable);
    }

    public void copyTo(SopremoRecord to) {
        if (this.binaryRepresentation.size() > 0) {
            to.binaryRepresentation.clear();
            to.binaryRepresentation.addElements(0, this.binaryRepresentation.elements(), 0, this.binaryRepresentation.size());
            to.offsets = (int[])this.offsets.clone();
        } else {
            to.binaryRepresentation.clear();
        }
        to.node = this.node.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SopremoRecord other = (SopremoRecord)obj;
        return this.getOrParseNode().equals(other.getOrParseNode());
    }

    public IJsonNode getKey(int expressionIndex, NodeCache nodeCache) {
        int offset = this.getKeyOffset(expressionIndex);
        if (offset == -1) {
            return MissingNode.getInstance();
        }
        return this.getValueAtOffset(offset, nodeCache);
    }

    public IJsonNode getNode() {
        return this.node;
    }

    public IJsonNode getOrParseNode() {
        if (this.node == null) {
            this.node = this.parseNode();
            return this.node;
        }
        return this.node;
    }

    public IJsonNode getValueAtOffset(int offset, NodeCache nodeCache) {
        if (offset == 0) {
            return this.getOrParseNode();
        }
        this.input.setBuffer(this.binaryRepresentation.elements(), offset, this.binaryRepresentation.size());
        return this.readRecursively(nodeCache);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getOrParseNode().hashCode();
        return result;
    }

    public IJsonNode parseNode() {
        this.input.setBuffer(this.binaryRepresentation.elements(), 0, this.binaryRepresentation.size());
        return this.readRecursively(this.node);
    }

    public void setNode(IJsonNode node) {
        if (node == null) {
            throw new NullPointerException("node must not be null");
        }
        this.node = node;
    }

    void read(DataInputView in, SopremoRecordLayout layout) throws IOException {
        this.node = null;
        int numKeys = layout.getNumKeys();
        if (numKeys != this.offsets.length) {
            this.offsets = new int[numKeys];
        }
        for (int index = 0; index < numKeys; ++index) {
            this.offsets[index] = in.readInt();
            if (this.offsets[index] != 0) continue;
            throw new IllegalStateException("Attempt to read zero offset");
        }
        int size = in.readInt();
        if (size <= 0) {
            throw new IllegalStateException("Attempt to read zero length binary representation");
        }
        this.binaryRepresentation.size(size);
        in.readFully(this.binaryRepresentation.elements(), 0, size);
    }

    void write(DataOutputView out, SopremoRecordLayout layout) throws IOException {
        if (this.node != null) {
            this.binaryRepresentation.clear();
            int numKeys = layout.getNumKeys();
            if (numKeys != this.offsets.length) {
                this.offsets = new int[numKeys];
            }
            Arrays.fill(this.offsets, -1);
            this.writeRecursivelyToBuffer(this.node, layout.getExpressionIndex());
            EvaluationExpression[] calculatedKeyExpressions = layout.getCalculatedKeyExpressions();
            for (int index = 0; index < calculatedKeyExpressions.length; ++index) {
                this.offsets[index + layout.getNumDirectDataKeys()] = this.position();
                IJsonNode calculatedValue = calculatedKeyExpressions[index].evaluate(this.node);
                this.kryo.writeClass(this.output, calculatedValue.getType());
                this.kryo.writeObject(this.output, (Object)calculatedValue);
            }
            this.output.flush();
        } else if (this.binaryRepresentation.size() == 0) {
            throw new IllegalStateException("Attempt to write zero length binary representation");
        }
        for (int index = 0; index < this.offsets.length; ++index) {
            if (this.offsets[index] == 0) {
                throw new IllegalStateException();
            }
            out.writeInt(this.offsets[index]);
        }
        int size = this.binaryRepresentation.size();
        out.writeInt(size);
        out.write(this.binaryRepresentation.elements(), 0, size);
    }

    private NodeDeserializer<IJsonNode> getDeserializer(Class<? extends IJsonNode> type) {
        NodeDeserializer<IJsonNode> deserializer = this.deserializers.get(type);
        if (deserializer == null) {
            NodeDeserializer<IJsonNode> defaultSerializer = this.deserializers.get(IJsonNode.class);
            this.deserializers.put(type, defaultSerializer);
            return defaultSerializer;
        }
        return deserializer;
    }

    private int getKeyOffset(int expressionIndex) {
        if (expressionIndex == Integer.MAX_VALUE) {
            return 0;
        }
        return this.offsets[expressionIndex];
    }

    private NodeSerializer<IJsonNode> getSerializer(Class<? extends IJsonNode> type) {
        NodeSerializer<IJsonNode> serializer = this.serializers.get(type);
        if (serializer == null) {
            NodeSerializer<IJsonNode> defaultSerializer = this.serializers.get(IJsonNode.class);
            this.serializers.put(type, defaultSerializer);
            return defaultSerializer;
        }
        return serializer;
    }

    private int position() {
        return this.binaryRepresentation.size() + this.output.position();
    }

    private IJsonNode readRecursively(IJsonNode possibleTarget) {
        Registration registration = this.kryo.readClass(this.input);
        Class type = registration.getType();
        return this.getDeserializer(type).read(possibleTarget == null || possibleTarget.getType() != type ? null : possibleTarget, registration);
    }

    private IJsonNode readRecursively(NodeCache nodeCache) {
        Registration registration = this.kryo.readClass(this.input);
        Class type = registration.getType();
        return this.getDeserializer(type).read((IJsonNode)nodeCache.getNode(type), registration);
    }

    private void writeRecursivelyToBuffer(IJsonNode node, ExpressionIndex expressionIndex) {
        NodeSerializer<IJsonNode> serializer = this.getSerializer(node.getType());
        this.kryo.writeClass(this.output, node.getType());
        if (node instanceof TypedObjectNode) {
            serializer.write(((TypedObjectNode)node).getBackingNode(), expressionIndex);
        } else {
            serializer.write(node, expressionIndex);
        }
    }

    private class PrimitiveSerializer
    implements NodeSerializer<IJsonNode>,
    NodeDeserializer<IJsonNode> {
        private PrimitiveSerializer() {
        }

        @Override
        public IJsonNode read(IJsonNode target, Registration registration) {
            Serializer serializer = registration.getSerializer();
            if (target != null && serializer instanceof ReusingSerializer && registration.getType() == target.getClass()) {
                return ((ReusingSerializer)serializer).read(SopremoRecord.this.kryo, SopremoRecord.this.input, target, registration.getType());
            }
            return (IJsonNode)serializer.read(SopremoRecord.this.kryo, SopremoRecord.this.input, registration.getType());
        }

        @Override
        public void write(IJsonNode node, ExpressionIndex expressionIndex) {
            SopremoRecord.this.kryo.writeObject(SopremoRecord.this.output, (Object)node);
        }
    }

    private class ObjectSerializer
    implements NodeSerializer<IObjectNode>,
    NodeDeserializer<IObjectNode> {
        private ObjectSerializer() {
        }

        @Override
        public IObjectNode read(IObjectNode target, Registration registration) {
            if (target != null) {
                target.clear();
            } else {
                target = new ObjectNode();
            }
            int size = SopremoRecord.this.input.readInt();
            for (int index = 0; index < size; ++index) {
                String key = SopremoRecord.this.input.readString();
                target.put(key, SopremoRecord.this.readRecursively(null));
            }
            return target;
        }

        @Override
        public void write(IObjectNode node, ExpressionIndex expressionIndex) {
            SortedSet<String> fieldNames = node.getFieldNames();
            SopremoRecord.this.output.writeInt(fieldNames.size());
            for (String fieldName : fieldNames) {
                ExpressionIndex subIndex;
                SopremoRecord.this.output.writeString(fieldName);
                if (expressionIndex != null) {
                    subIndex = expressionIndex.subIndex(fieldName);
                    if (subIndex != null && subIndex.getExpression() != null) {
                        ((SopremoRecord)SopremoRecord.this).offsets[subIndex.getKeyIndex()] = SopremoRecord.this.position();
                    }
                } else {
                    subIndex = null;
                }
                SopremoRecord.this.writeRecursivelyToBuffer(node.get(fieldName), subIndex);
            }
        }
    }

    private static interface NodeSerializer<T extends IJsonNode> {
        public void write(T var1, ExpressionIndex var2);
    }

    private static interface NodeDeserializer<T extends IJsonNode> {
        public T read(T var1, Registration var2);
    }

    private class CachingArrayDeserializer
    implements NodeDeserializer<CachingArrayNode<IJsonNode>> {
        private CachingArrayDeserializer() {
        }

        @Override
        public CachingArrayNode<IJsonNode> read(CachingArrayNode<IJsonNode> target, Registration registration) {
            if (target != null) {
                target.clear();
            } else {
                target = new CachingArrayNode();
            }
            int size = SopremoRecord.this.input.readInt();
            target.clear();
            for (int index = 0; index < size; ++index) {
                target.add(SopremoRecord.this.readRecursively(target.getUnusedNode()));
            }
            return target;
        }
    }

    private class ArraySerializer
    implements NodeSerializer<IArrayNode<IJsonNode>> {
        private ArraySerializer() {
        }

        @Override
        public void write(IArrayNode<IJsonNode> node, ExpressionIndex expressionIndex) {
            int size = node.size();
            SopremoRecord.this.output.writeInt(size);
            for (int index = 0; index < size; ++index) {
                ExpressionIndex subIndex;
                if (expressionIndex != null) {
                    subIndex = this.getSubIndex(expressionIndex, size, index);
                    if (subIndex != null && subIndex.getExpression() != null) {
                        ((SopremoRecord)SopremoRecord.this).offsets[subIndex.getKeyIndex()] = SopremoRecord.this.position();
                    }
                } else {
                    subIndex = null;
                }
                SopremoRecord.this.writeRecursivelyToBuffer(node.get(index), subIndex);
            }
        }

        private ExpressionIndex getSubIndex(ExpressionIndex expressionIndex, int size, int index) {
            ExpressionIndex subIndex = expressionIndex.get(index);
            if (subIndex != null) {
                return subIndex;
            }
            return expressionIndex.get(index - size);
        }
    }

    public static class SopremoRecordKryoSerializer<Node extends IJsonNode>
    extends ReusingSerializer<SopremoRecord> {
        public SopremoRecord copy(Kryo kryo, SopremoRecord original) {
            SopremoRecord copy = new SopremoRecord();
            copy.node = original.node;
            copy.binaryRepresentation.addElements(0, original.binaryRepresentation.elements(), 0, original.binaryRepresentation.size());
            return copy;
        }

        @Override
        public SopremoRecord read(Kryo kryo, Input input, Class<SopremoRecord> type) {
            return this.read(kryo, input, new SopremoRecord(), type);
        }

        @Override
        public SopremoRecord read(Kryo kryo, Input input, SopremoRecord oldInstance, Class<SopremoRecord> type) {
            oldInstance.binaryRepresentation.clear();
            int size = input.readInt(true);
            oldInstance.binaryRepresentation.size(size);
            input.read(oldInstance.binaryRepresentation.elements(), 0, size);
            return oldInstance;
        }

        public void write(Kryo kryo, Output output, SopremoRecord object) {
            if (object.binaryRepresentation.isEmpty()) {
                object.writeRecursivelyToBuffer(object.node, SopremoRecordLayout.EMPTY.getExpressionIndex());
                object.output.flush();
            }
            output.writeInt(object.binaryRepresentation.size(), true);
            output.writeBytes(object.binaryRepresentation.elements(), 0, object.binaryRepresentation.size());
        }
    }
}

