/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.serialization;

import com.google.common.base.Predicate;
import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.ISopremoType;
import eu.stratosphere.sopremo.expressions.ArrayAccess;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.InputSelection;
import eu.stratosphere.sopremo.expressions.ObjectAccess;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javolution.text.TypeFormat;

public class ExpressionIndex
extends AbstractSopremoType {
    private final EvaluationExpression expression;
    private final Object2ObjectMap<String, ExpressionIndex> objectAccesses = new Object2ObjectOpenHashMap();
    private final Int2ObjectMap<ExpressionIndex> arrayAccesses = new Int2ObjectOpenHashMap();
    private static final ExpressionIndex EMPTY_INDEX = null;
    private final int keyIndex;
    private static final Set<Class<?>> SupportedClasses = new HashSet();

    public ExpressionIndex() {
        this(EvaluationExpression.VALUE, -1);
    }

    protected ExpressionIndex(EvaluationExpression evaluationExpression, int keyIndex) {
        this.expression = evaluationExpression;
        this.objectAccesses.defaultReturnValue((Object)EMPTY_INDEX);
        this.arrayAccesses.defaultReturnValue((Object)EMPTY_INDEX);
        this.keyIndex = keyIndex;
    }

    public boolean add(EvaluationExpression expression, int keyIndex) {
        final LinkedList<EvaluationExpression> expressionChain = new LinkedList<EvaluationExpression>();
        final Class<?> type = expression.getClass();
        if (expression.findFirst((Predicate<? super EvaluationExpression>)new Predicate<EvaluationExpression>(){

            public boolean apply(EvaluationExpression expression) {
                expressionChain.add(expression);
                return !SupportedClasses.contains(type) || expression instanceof ArrayAccess && ((ArrayAccess)expression).isSelectingRange();
            }
        }) != null) {
            return false;
        }
        this.add(expressionChain, expression, keyIndex);
        return true;
    }

    public void appendAsString(Appendable builder) throws IOException {
        builder.append("ExpressionIndex ");
        if (this.expression != null) {
            this.expression.appendAsString(builder);
        }
        if (!this.objectAccesses.isEmpty()) {
            builder.append(", objectAccesses=");
            this.append(builder, (Iterable<? extends ISopremoType>)this.objectAccesses.values(), ", ");
        }
        if (!this.arrayAccesses.isEmpty()) {
            builder.append(", arrayAccesses=");
            this.append(builder, (Iterable<? extends ISopremoType>)this.arrayAccesses.values(), ", ");
        }
        builder.append(", keyIndex=");
        TypeFormat.format((int)this.keyIndex, (Appendable)builder);
        builder.append("]");
    }

    public ExpressionIndex get(int index) {
        return (ExpressionIndex)this.arrayAccesses.get(index);
    }

    public EvaluationExpression getExpression() {
        return this.expression;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public ExpressionIndex subIndex(String fieldName) {
        return (ExpressionIndex)this.objectAccesses.get((Object)fieldName);
    }

    private void add(Deque<EvaluationExpression> expressionChain, EvaluationExpression expression, int keyIndex) {
        if (expressionChain.isEmpty()) {
            return;
        }
        EvaluationExpression currentExpression = expressionChain.removeLast();
        if (currentExpression instanceof ObjectAccess) {
            ObjectAccess objectAccess = (ObjectAccess)currentExpression;
            ExpressionIndex subIndex = (ExpressionIndex)this.objectAccesses.get((Object)objectAccess.getField());
            if (subIndex == EMPTY_INDEX) {
                subIndex = new ExpressionIndex(objectAccess.cloneSegment(), keyIndex);
                this.objectAccesses.put((Object)objectAccess.getField(), (Object)subIndex);
            }
            subIndex.add(expressionChain, expression, keyIndex);
        } else if (currentExpression instanceof InputSelection) {
            InputSelection inputSelection = (InputSelection)currentExpression;
            ExpressionIndex subIndex = (ExpressionIndex)this.arrayAccesses.get(inputSelection.getIndex());
            if (subIndex == EMPTY_INDEX) {
                subIndex = new ExpressionIndex(inputSelection.asArrayAccess(), keyIndex);
                this.arrayAccesses.put(inputSelection.getIndex(), (Object)subIndex);
            }
            subIndex.add(expressionChain, expression, keyIndex);
        } else if (currentExpression instanceof ArrayAccess) {
            ArrayAccess arrayAccess = (ArrayAccess)currentExpression;
            int index = arrayAccess.getStartIndex();
            ExpressionIndex subIndex = (ExpressionIndex)this.arrayAccesses.get(index);
            if (subIndex == EMPTY_INDEX) {
                subIndex = new ExpressionIndex(new ArrayAccess(index), keyIndex);
                this.arrayAccesses.put(index, (Object)subIndex);
            }
            subIndex.add(expressionChain, expression, keyIndex);
        } else if (currentExpression == EvaluationExpression.VALUE) {
            this.add(expressionChain, currentExpression, keyIndex);
        }
    }

    static {
        SupportedClasses.add(EvaluationExpression.VALUE.getClass());
        SupportedClasses.add(ArrayAccess.class);
        SupportedClasses.add(ObjectAccess.class);
        SupportedClasses.add(InputSelection.class);
    }
}

