/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.pact;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.reflect.TypeToken;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.ISopremoType;
import eu.stratosphere.sopremo.SopremoEnvironment;
import eu.stratosphere.sopremo.cache.NodeCache;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.UnevaluableExpression;
import eu.stratosphere.sopremo.function.SopremoFunction;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.ReusingSerializer;
import eu.stratosphere.sopremo.type.typed.ITypedObjectNode;
import eu.stratosphere.sopremo.type.typed.TypedObjectNode;
import eu.stratosphere.sopremo.type.typed.TypedObjectNodeFactory;
import eu.stratosphere.util.ICloneable;
import eu.stratosphere.util.KryoUtil;
import eu.stratosphere.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.SimpleLog;

public class SopremoUtil {
    public static final boolean DEBUG = true;
    public static final Log NORMAL_LOG = LogFactory.getLog(SopremoUtil.class);
    public static final Log TRACE_LOG = new SimpleLog(SopremoUtil.class.getName());
    public static Log LOG;
    private static final String CONTEXT = "sopremo.context";
    private static final TypeToken<?> ITypedObjectNodeType;
    private static final Charset BINARY_CHARSET;

    public static void append(Appendable appendable, Object ... objects) throws IOException {
        for (Object object : objects) {
            if (object instanceof CharSequence) {
                appendable.append((CharSequence)object);
                continue;
            }
            if (object instanceof ISopremoType) {
                ((ISopremoType)object).appendAsString(appendable);
                continue;
            }
            if (object instanceof Character) {
                appendable.append(((Character)object).charValue());
                continue;
            }
            appendable.append(String.valueOf(object));
        }
    }

    public static void assertArguments(SopremoFunction function, int numberOfArguments) {
        if (!function.accepts(numberOfArguments)) {
            throw new IllegalArgumentException(String.format("Cannot use the given function as it does not accept %d arguments", numberOfArguments));
        }
    }

    public static void configureWithTransferredState(Object instance, Class<?> stopClass, Configuration parameters) {
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field stubField : clazz.getDeclaredFields()) {
                Object fieldValue;
                if ((stubField.getModifiers() & 0x88) != 0 || (fieldValue = SopremoUtil.getObject(parameters, stubField.getName(), null)) == null) continue;
                try {
                    stubField.setAccessible(true);
                    stubField.set(instance, SopremoUtil.getObject(parameters, stubField.getName(), null));
                }
                catch (Exception e) {
                    LOG.error((Object)String.format("Could not set field %s of class %s: %s", stubField.getName(), clazz, StringUtils.stringifyException((Throwable)e)));
                }
            }
            if (clazz == stopClass) break;
        }
    }

    public static <T extends IJsonNode> T copyInto(T node, IJsonNode possibleTarget) {
        if (possibleTarget == null || possibleTarget.getType() != node.getType()) {
            return (T)node.clone();
        }
        possibleTarget.copyValueFrom(node);
        return (T)possibleTarget;
    }

    public static <T extends IJsonNode> T copyInto(T node, NodeCache nodeCache) {
        IJsonNode target = nodeCache.getNode(node.getType());
        target.copyValueFrom(node);
        return (T)target;
    }

    public static <T extends ICloneable> List<T> deepClone(List<T> originals) {
        ArrayList<ICloneable> clones = new ArrayList<ICloneable>(originals.size());
        for (ICloneable t : originals) {
            clones.add((ICloneable)t.clone());
        }
        return clones;
    }

    public static <K, V extends ICloneable> Map<K, V> deepClone(Map<K, V> originals) {
        HashMap<K, ICloneable> clones = new HashMap<K, ICloneable>(originals.size());
        for (Map.Entry<K, V> original : originals.entrySet()) {
            clones.put(original.getKey(), (ICloneable)((ICloneable)original.getValue()).clone());
        }
        return clones;
    }

    public static <K, V> Map<K, V> deepCloneIfPossible(Map<K, V> originals) {
        HashMap<K, V> clones = new HashMap<K, V>(originals.size());
        for (Map.Entry<K, V> original : originals.entrySet()) {
            Object value = original.getValue();
            if (value instanceof ICloneable) {
                value = ((ICloneable)value).clone();
            }
            clones.put(original.getKey(), value);
        }
        return clones;
    }

    public static <T> T deserialize(byte[] bytes, Class<T> clazz) {
        Kryo kryo = KryoUtil.getKryo();
        Input input = new Input(bytes);
        kryo.reset();
        kryo.setClassLoader(SopremoEnvironment.getInstance().getClassLoader());
        return clazz.cast(kryo.readClassAndObject(input));
    }

    public static <T> T deserialize(DataInput in, Class<T> clazz) throws IOException {
        byte[] buffer = new byte[in.readInt()];
        in.readFully(buffer);
        return SopremoUtil.deserialize(buffer, clazz);
    }

    public static <T> T deserializeInto(Kryo kryo, Input input, T oldNode) {
        Registration registration = kryo.readClass(input);
        Serializer serializer = registration.getSerializer();
        if (serializer instanceof ReusingSerializer && registration.getType() == oldNode.getClass()) {
            return ((ReusingSerializer)serializer).read(kryo, input, oldNode, registration.getType());
        }
        return (T)serializer.read(kryo, input, registration.getType());
    }

    public static EvaluationContext getEvaluationContext(Configuration config) {
        return SopremoUtil.getObject(config, CONTEXT, null);
    }

    public static <T> T getObject(Configuration config, String keyName, T defaultValue) {
        String stringRepresentation = config.getString(keyName, null);
        if (stringRepresentation == null) {
            return defaultValue;
        }
        byte[] bytes = stringRepresentation.getBytes(BINARY_CHARSET);
        return (T)SopremoUtil.deserialize(bytes, Object.class);
    }

    public static <T extends IJsonNode> void replaceWithCopy(IArrayNode<T> arrayNode, int index, T element) {
        T oldValue = arrayNode.get(index);
        if (oldValue.getType() == element.getType()) {
            oldValue.copyValueFrom(element);
        } else {
            arrayNode.set(index, element.clone());
        }
    }

    public static void replaceWithCopy(IObjectNode node, String field, IJsonNode element) {
        Object oldValue = node.get(field);
        if (oldValue.getType() == node.getType()) {
            oldValue.copyValueFrom(node);
        } else {
            node.put(field, element.clone());
        }
    }

    public static byte[] serializable(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        Kryo kryo = KryoUtil.getKryo();
        kryo.reset();
        kryo.writeClassAndObject(output, object);
        output.close();
        return baos.toByteArray();
    }

    public static void setEvaluationContext(Configuration config, EvaluationContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        SopremoUtil.setObject(config, CONTEXT, context);
    }

    public static void setObject(Configuration config, String keyName, Object object) {
        config.setString(keyName, new String(SopremoUtil.serializable(object), BINARY_CHARSET));
    }

    public static void trace() {
        LOG = TRACE_LOG;
    }

    public static <S, T> void transferFieldsToConfiguration(S sourceInstance, Class<? super S> stopClass, Configuration configuration, Class<T> targetClass, Class<? super T> targetStopClass) {
        for (Class<T> tarClass = targetClass; tarClass != null; tarClass = tarClass.getSuperclass()) {
            block4: for (Field stubField : tarClass.getDeclaredFields()) {
                if ((stubField.getModifiers() & 0x88) != 0) continue;
                for (Class<?> srcClass = sourceInstance.getClass(); srcClass != null; srcClass = srcClass.getSuperclass()) {
                    try {
                        Field thisField = srcClass.getDeclaredField(stubField.getName());
                        thisField.setAccessible(true);
                        Object value = thisField.get(sourceInstance);
                        if (value instanceof EvaluationExpression && ((EvaluationExpression)value).findFirst(UnevaluableExpression.class) != null) {
                            throw new IllegalStateException(String.format("Cannot serialize field %s with unevaluable expressions %s", thisField.getName(), value));
                        }
                        if (value != null) {
                            SopremoUtil.setObject(configuration, stubField.getName(), value);
                        }
                    }
                    catch (NoSuchFieldException e) {
                    }
                    catch (Exception e) {
                        LOG.error((Object)String.format("Could not serialize field %s of class %s: %s", stubField.getName(), sourceInstance.getClass().getSimpleName(), e));
                        throw new RuntimeException(String.format("Could not serialize field %s of class %s: %s", stubField.getName(), sourceInstance.getClass().getSimpleName(), e), e);
                    }
                    if (srcClass == stopClass) continue block4;
                }
            }
            if (tarClass == targetStopClass) break;
        }
    }

    public static void untrace() {
        LOG = NORMAL_LOG;
    }

    static TypedObjectNode[] getTypedNodes(TypeToken<?> boundFunction) {
        Type[] actualTypeArguments = ((ParameterizedType)boundFunction.getType()).getActualTypeArguments();
        TypedObjectNode[] nodes = new TypedObjectNode[actualTypeArguments.length - 1];
        for (int index = 0; index < nodes.length; ++index) {
            if (!ITypedObjectNodeType.isAssignableFrom(actualTypeArguments[0])) continue;
            nodes[index] = (TypedObjectNode)TypedObjectNodeFactory.getInstance().getTypedObjectForInterface(TypeToken.of((Type)actualTypeArguments[0]).getRawType());
        }
        return nodes;
    }

    static {
        ((SimpleLog)TRACE_LOG).setLevel(1);
        LOG = NORMAL_LOG;
        ITypedObjectNodeType = TypeToken.of(ITypedObjectNode.class);
        BINARY_CHARSET = Charset.forName("ISO-8859-1");
    }
}

