/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.pact;

import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.serialization.SopremoRecord;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.util.Collector;

public class JsonCollector<T extends IJsonNode>
implements Collector<T> {
    private Collector<SopremoRecord> collector;
    private final EvaluationExpression resultProjection;
    private final SopremoRecord record = new SopremoRecord();

    public JsonCollector(EvaluationContext context) {
        this.resultProjection = context.getResultProjection();
    }

    public void close() {
        this.collector.close();
    }

    public void collect(T value) {
        IJsonNode resultValue = this.resultProjection.evaluate((IJsonNode)value);
        if (SopremoUtil.LOG.isTraceEnabled()) {
            SopremoUtil.LOG.trace((Object)String.format(" to %s", resultValue));
        }
        this.record.setNode(resultValue);
        this.collector.collect((Object)this.record);
    }

    public void configure(Collector<SopremoRecord> collector) {
        this.collector = collector;
    }
}

