/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.pact;

import com.google.common.reflect.TypeToken;
import eu.stratosphere.api.common.functions.AbstractFunction;
import eu.stratosphere.api.common.functions.GenericMapper;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.SopremoEnvironment;
import eu.stratosphere.sopremo.pact.JsonCollector;
import eu.stratosphere.sopremo.pact.SopremoFunction;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.serialization.SopremoRecord;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.typed.TypedObjectNode;
import eu.stratosphere.util.Collector;

public abstract class GenericSopremoMap<In extends IJsonNode, Out extends IJsonNode>
extends AbstractFunction
implements GenericMapper<SopremoRecord, SopremoRecord>,
SopremoFunction {
    private EvaluationContext context;
    private JsonCollector<Out> collector;
    private TypedObjectNode typedInputNode;

    @Override
    public final EvaluationContext getContext() {
        return this.context;
    }

    public void map(SopremoRecord record, Collector<SopremoRecord> out) {
        IJsonNode input = record.getNode();
        if (SopremoUtil.LOG.isTraceEnabled()) {
            SopremoUtil.LOG.trace((Object)String.format("%s %s", this.getContext().getOperatorDescription(), input));
        }
        this.collector.configure(out);
        try {
            this.map((In)(this.typedInputNode == null ? input : this.typedInputNode.withBackingNode((IObjectNode)input)), this.collector);
        }
        catch (RuntimeException e) {
            SopremoUtil.LOG.error((Object)String.format("Error occurred @ %s with %s: %s", this.getContext().getOperatorDescription(), input, e));
            throw e;
        }
    }

    public void open(Configuration parameters) {
        SopremoEnvironment.getInstance().setConfiguration(parameters);
        this.context = SopremoEnvironment.getInstance().getEvaluationContext();
        this.collector = new JsonCollector(this.context);
        this.typedInputNode = SopremoUtil.getTypedNodes(TypeToken.of(this.getClass()).getSupertype(GenericSopremoMap.class))[0];
        SopremoUtil.configureWithTransferredState(this, GenericSopremoMap.class, parameters);
    }

    protected abstract void map(In var1, JsonCollector<Out> var2);
}

