/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.pact;

import com.google.common.reflect.TypeToken;
import eu.stratosphere.api.common.functions.AbstractFunction;
import eu.stratosphere.api.common.functions.GenericJoiner;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.SopremoEnvironment;
import eu.stratosphere.sopremo.pact.JsonCollector;
import eu.stratosphere.sopremo.pact.SopremoFunction;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.serialization.SopremoRecord;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.typed.TypedObjectNode;
import eu.stratosphere.util.Collector;

public abstract class GenericSopremoJoin<Left extends IJsonNode, Right extends IJsonNode, Out extends IJsonNode>
extends AbstractFunction
implements GenericJoiner<SopremoRecord, SopremoRecord, SopremoRecord>,
SopremoFunction {
    private EvaluationContext context;
    private JsonCollector<Out> collector;
    private TypedObjectNode typedInputNode1;
    private TypedObjectNode typedInputNode2;

    @Override
    public final EvaluationContext getContext() {
        return this.context;
    }

    public void join(SopremoRecord record1, SopremoRecord record2, Collector<SopremoRecord> out) {
        this.collector.configure(out);
        IJsonNode input1 = record1.getNode();
        IJsonNode input2 = record2.getNode();
        if (SopremoUtil.LOG.isTraceEnabled()) {
            SopremoUtil.LOG.trace((Object)String.format("%s %s/%s", this.getContext().getOperatorDescription(), input1, input2));
        }
        try {
            this.join((Left)(this.typedInputNode1 == null ? input1 : this.typedInputNode1.withBackingNode((IObjectNode)input1)), (Right)(this.typedInputNode2 == null ? input2 : this.typedInputNode2.withBackingNode((IObjectNode)input2)), this.collector);
        }
        catch (RuntimeException e) {
            SopremoUtil.LOG.error((Object)String.format("Error occurred @ %s with %s/%s: %s", this.getContext().getOperatorDescription(), input1, input2, e));
            throw e;
        }
    }

    public void open(Configuration parameters) throws Exception {
        SopremoEnvironment.getInstance().setConfiguration(parameters);
        this.context = SopremoEnvironment.getInstance().getEvaluationContext();
        this.collector = new JsonCollector(this.context);
        TypedObjectNode[] typedNodes = SopremoUtil.getTypedNodes(TypeToken.of(this.getClass()).getSupertype(GenericSopremoJoin.class));
        this.typedInputNode1 = typedNodes[0];
        this.typedInputNode2 = typedNodes[1];
        SopremoUtil.configureWithTransferredState(this, GenericSopremoJoin.class, parameters);
    }

    protected abstract void join(Left var1, Right var2, JsonCollector<Out> var3);
}

