/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.pact;

import com.google.common.reflect.TypeToken;
import eu.stratosphere.api.common.functions.AbstractFunction;
import eu.stratosphere.api.common.functions.GenericCoGrouper;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.SopremoEnvironment;
import eu.stratosphere.sopremo.pact.JsonCollector;
import eu.stratosphere.sopremo.pact.RecordToJsonIterator;
import eu.stratosphere.sopremo.pact.SopremoFunction;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.pact.TypedRecordToJsonIterator;
import eu.stratosphere.sopremo.pact.UntypedRecordToJsonIterator;
import eu.stratosphere.sopremo.serialization.SopremoRecord;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IStreamNode;
import eu.stratosphere.sopremo.type.StreamNode;
import eu.stratosphere.sopremo.type.typed.TypedObjectNode;
import eu.stratosphere.util.Collector;
import java.util.Iterator;

public abstract class GenericSopremoCoGroup<LeftElem extends IJsonNode, RightElem extends IJsonNode, Out extends IJsonNode>
extends AbstractFunction
implements GenericCoGrouper<SopremoRecord, SopremoRecord, SopremoRecord>,
SopremoFunction {
    private EvaluationContext context;
    private JsonCollector<Out> collector;
    private RecordToJsonIterator<LeftElem> cachedIterator1;
    private RecordToJsonIterator<RightElem> cachedIterator2;
    private final StreamNode<LeftElem> leftArray = new StreamNode();
    private final StreamNode<RightElem> rightArray = new StreamNode();

    public void coGroup(Iterator<SopremoRecord> records1, Iterator<SopremoRecord> records2, Collector<SopremoRecord> out) {
        this.collector.configure(out);
        this.cachedIterator1.setIterator(records1);
        this.cachedIterator2.setIterator(records2);
        try {
            if (SopremoUtil.LOG.isTraceEnabled()) {
                ArrayNode<LeftElem> leftArray = new ArrayNode<LeftElem>(this.leftArray);
                ArrayNode<RightElem> rightArray = new ArrayNode<RightElem>(this.rightArray);
                SopremoUtil.LOG.trace((Object)String.format("%s %s/%s", this.getContext().getOperatorDescription(), leftArray, rightArray));
                this.coGroup(new StreamNode<LeftElem>(leftArray.iterator()), new StreamNode<RightElem>(rightArray.iterator()), this.collector);
            } else {
                this.coGroup(this.leftArray, this.rightArray, this.collector);
            }
        }
        catch (RuntimeException e) {
            SopremoUtil.LOG.error((Object)String.format("Error occurred @ %s with %s/%s: %s", this.getContext().getOperatorDescription(), this.leftArray, this.rightArray, e));
            throw e;
        }
    }

    public void combineFirst(Iterator<SopremoRecord> records, Collector<SopremoRecord> out) {
        throw new UnsupportedOperationException();
    }

    public void combineSecond(Iterator<SopremoRecord> records, Collector<SopremoRecord> out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final EvaluationContext getContext() {
        return this.context;
    }

    public void open(Configuration parameters) throws Exception {
        SopremoEnvironment.getInstance().setConfiguration(parameters);
        this.context = SopremoEnvironment.getInstance().getEvaluationContext();
        this.collector = new JsonCollector(this.context);
        SopremoUtil.configureWithTransferredState(this, GenericSopremoCoGroup.class, parameters);
        TypedObjectNode[] typedInputNodes = SopremoUtil.getTypedNodes(TypeToken.of(this.getClass()).getSupertype(GenericSopremoCoGroup.class));
        this.cachedIterator1 = typedInputNodes[0] == null ? new UntypedRecordToJsonIterator() : new TypedRecordToJsonIterator(typedInputNodes[0]);
        this.cachedIterator2 = typedInputNodes[1] == null ? new UntypedRecordToJsonIterator() : new TypedRecordToJsonIterator(typedInputNodes[1]);
        this.leftArray.setNodeIterator(this.cachedIterator1);
        this.rightArray.setNodeIterator(this.cachedIterator2);
    }

    protected abstract void coGroup(IStreamNode<LeftElem> var1, IStreamNode<RightElem> var2, JsonCollector<Out> var3);
}

