/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.packages;

import eu.stratosphere.sopremo.packages.AbstractRegistry;
import eu.stratosphere.sopremo.packages.ITypeRegistry;
import eu.stratosphere.sopremo.packages.NameChooser;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultTypeRegistry
extends AbstractRegistry<Class<? extends IJsonNode>>
implements ITypeRegistry {
    private final Map<String, Class<? extends IJsonNode>> elements = new HashMap<String, Class<? extends IJsonNode>>();
    private final List<Class<? extends IJsonNode>> typeList = new ArrayList<Class<? extends IJsonNode>>();

    public DefaultTypeRegistry() {
    }

    public DefaultTypeRegistry(NameChooser typeNameChooser) {
        super(typeNameChooser);
    }

    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("Registry: {");
        boolean first = true;
        for (Class<? extends IJsonNode> type : this.typeList) {
            appendable.append(type.getName());
            if (first) {
                first = false;
                continue;
            }
            appendable.append(", ");
        }
        appendable.append("}");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultTypeRegistry other = (DefaultTypeRegistry)obj;
        return this.elements.equals(other.elements) && this.typeList.equals(other.typeList);
    }

    @Override
    public Class<? extends IJsonNode> get(String name) {
        return this.elements.get(name);
    }

    @Override
    public List<Class<? extends IJsonNode>> getTypes() {
        return this.typeList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.elements.hashCode();
        result = 31 * result + this.typeList.hashCode();
        return result;
    }

    @Override
    public Set<String> keySet() {
        return this.elements.keySet();
    }

    @Override
    public void put(Class<? extends IJsonNode> type) {
        this.put(type.getName(), type);
    }

    @Override
    public void put(String name, Class<? extends IJsonNode> element) {
        this.elements.put(name, element);
        this.typeList.add(element);
    }
}

