/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.packages;

import eu.stratosphere.sopremo.ISopremoType;
import eu.stratosphere.sopremo.packages.AbstractRegistry;
import eu.stratosphere.sopremo.packages.IRegistry;
import eu.stratosphere.sopremo.packages.NameChooser;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DefaultRegistry<T extends ISopremoType>
extends AbstractRegistry<T>
implements IRegistry<T> {
    private final Map<String, T> elements = new HashMap<String, T>();

    public DefaultRegistry() {
    }

    public DefaultRegistry(NameChooser nameChooser) {
        super(nameChooser);
    }

    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("Registry: {");
        boolean first = true;
        for (Map.Entry<String, T> method : this.elements.entrySet()) {
            if (first) {
                first = false;
            } else {
                appendable.append(", ");
            }
            appendable.append(method.getKey()).append(": ");
            ((ISopremoType)method.getValue()).appendAsString(appendable);
        }
        appendable.append("}");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DefaultRegistry other = (DefaultRegistry)obj;
        return this.elements.equals(other.elements);
    }

    @Override
    public T get(String name) {
        return (T)((ISopremoType)this.elements.get(name));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.elements.hashCode();
        return result;
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.elements.keySet());
    }

    @Override
    public void put(String name, T element) {
        this.elements.put(name, element);
    }
}

