/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.packages;

import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.operator.Name;
import eu.stratosphere.sopremo.packages.NameChooser;
import java.io.IOException;
import java.util.Arrays;

public class DefaultNameChooser
extends AbstractSopremoType
implements NameChooser {
    private final int[] preferredOrder;

    public DefaultNameChooser(int ... preferredOrder) {
        this.preferredOrder = preferredOrder;
    }

    DefaultNameChooser() {
        this(0, 1, 2, 3);
    }

    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append(Arrays.toString(this.preferredOrder));
    }

    public String[] choose(String[] nouns, String[] verbs, String[] adjectives, String[] prepositions) {
        String[][] names = new String[][]{nouns, verbs, adjectives, prepositions};
        for (int pos : this.preferredOrder) {
            if (names[pos] == null || names[pos].length <= 0) continue;
            return names[pos];
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNameChooser other = (DefaultNameChooser)obj;
        return Arrays.equals(this.preferredOrder, other.preferredOrder);
    }

    @Override
    public String[] getNames(Name nameAnnotation) {
        return this.choose(nameAnnotation.noun(), nameAnnotation.verb(), nameAnnotation.adjective(), nameAnnotation.preposition());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.preferredOrder);
        return result;
    }
}

