/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.packages;

import eu.stratosphere.sopremo.ISopremoType;
import eu.stratosphere.sopremo.aggregation.Aggregation;
import eu.stratosphere.sopremo.aggregation.AggregationFunction;
import eu.stratosphere.sopremo.function.Callable;
import eu.stratosphere.sopremo.function.JavaMethod;
import eu.stratosphere.sopremo.function.SopremoFunction;
import eu.stratosphere.sopremo.packages.DefaultRegistry;
import eu.stratosphere.sopremo.packages.FunctionRegistryCallback;
import eu.stratosphere.sopremo.packages.IFunctionRegistry;
import eu.stratosphere.sopremo.packages.NameChooser;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.util.reflect.ReflectUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultFunctionRegistry
extends DefaultRegistry<Callable<?, ?>>
implements IFunctionRegistry {
    private final Map<String, Callable<?, ?>> methods = new HashMap();

    public DefaultFunctionRegistry() {
    }

    public DefaultFunctionRegistry(NameChooser nameChooser) {
        super(nameChooser);
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("Method registry: {");
        boolean first = true;
        for (Map.Entry<String, Callable<?, ?>> method : this.methods.entrySet()) {
            if (first) {
                first = false;
            } else {
                appendable.append(", ");
            }
            appendable.append(method.getKey()).append(": ");
            method.getValue().appendAsString(appendable);
        }
        appendable.append("}");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultFunctionRegistry other = (DefaultFunctionRegistry)obj;
        return this.methods.equals(other.methods);
    }

    @Override
    public Callable<?, ?> get(String name) {
        return this.methods.get(name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.methods.hashCode();
        return result;
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.methods.keySet());
    }

    @Override
    public void put(Class<?> javaFunctions) {
        Class<?>[] declaredClasses;
        List<Method> functions = this.getCompatibleMethods(ReflectUtil.getMethods(javaFunctions, null, (int[])new int[]{9}));
        for (Method method : functions) {
            this.put(method);
        }
        for (Class<?> innerClass : declaredClasses = javaFunctions.getDeclaredClasses()) {
            if ((innerClass.getModifiers() & 8) == 0) continue;
            try {
                if (Aggregation.class.isAssignableFrom(innerClass)) {
                    Aggregation aggregation = (Aggregation)ReflectUtil.newInstance(innerClass);
                    for (String name : this.getNames(innerClass)) {
                        this.put(name, new AggregationFunction(aggregation));
                    }
                    continue;
                }
                if (!SopremoFunction.class.isAssignableFrom(innerClass)) continue;
                SopremoFunction function = (SopremoFunction)ReflectUtil.newInstance(innerClass);
                for (String name : this.getNames(innerClass)) {
                    this.put(name, function);
                }
            }
            catch (Exception e) {
                SopremoUtil.LOG.warn((Object)String.format("Cannot access inner class %s: %s", innerClass, e));
            }
        }
        List declaredFields = ReflectUtil.getFields(javaFunctions, null, (int[])new int[]{25});
        for (Field field : declaredFields) {
            try {
                if (Aggregation.class.isAssignableFrom(field.getType())) {
                    Aggregation aggregation = (Aggregation)field.get(null);
                    for (String name : this.getNames(field)) {
                        this.put(name, new AggregationFunction(aggregation));
                    }
                    continue;
                }
                if (!SopremoFunction.class.isAssignableFrom(field.getType())) continue;
                SopremoFunction function = (SopremoFunction)field.get(null);
                for (String name : this.getNames(field)) {
                    this.put(name, function);
                }
            }
            catch (Throwable e) {
                SopremoUtil.LOG.warn((Object)String.format("Cannot access field %s: %s", field, e));
            }
        }
        if (FunctionRegistryCallback.class.isAssignableFrom(javaFunctions)) {
            ((FunctionRegistryCallback)ReflectUtil.newInstance(javaFunctions)).registerFunctions(this);
        }
    }

    @Override
    public void put(Method method) {
        String[] names = this.getNames(method);
        if (names == null) {
            names = new String[]{method.getName()};
        }
        for (String name : names) {
            ISopremoType javaMethod = this.get(name);
            if (javaMethod == null || !(javaMethod instanceof JavaMethod)) {
                javaMethod = this.createJavaMethod(name, method);
                this.put(name, (Callable<?, ?>)javaMethod);
            }
            ((JavaMethod)javaMethod).addSignature(method);
        }
    }

    @Override
    public void put(String name, Callable<?, ?> method) {
        this.methods.put(name, method);
    }

    @Override
    public void put(String registeredName, Class<?> clazz, String staticMethodName) {
        List<Method> functions = this.getCompatibleMethods(ReflectUtil.getMethods(clazz, (String)staticMethodName, (int[])new int[]{9}));
        if (functions.isEmpty()) {
            throw new IllegalArgumentException(String.format("Method %s not found in class %s", staticMethodName, clazz));
        }
        ISopremoType javaMethod = this.get(registeredName);
        if (javaMethod == null || !(javaMethod instanceof JavaMethod)) {
            javaMethod = this.createJavaMethod(registeredName, functions.get(0));
            this.put(registeredName, (Callable<?, ?>)javaMethod);
        }
        for (Method method : functions) {
            ((JavaMethod)javaMethod).addSignature(method);
        }
    }

    protected JavaMethod createJavaMethod(String registeredName, Method implementation) {
        JavaMethod javaMethod = new JavaMethod(registeredName);
        javaMethod.addSignature(implementation);
        return javaMethod;
    }

    private List<Method> getCompatibleMethods(List<Method> methods) {
        ArrayList<Method> functions = new ArrayList<Method>();
        for (Method method : methods) {
            boolean compatibleSignature = DefaultFunctionRegistry.isCompatibleSignature(method);
            if (SopremoUtil.LOG.isDebugEnabled()) {
                SopremoUtil.LOG.debug((Object)String.format("Method %s is %s compatible", method, compatibleSignature ? "" : " not"));
            }
            if (!compatibleSignature) continue;
            functions.add(method);
        }
        return functions;
    }

    private static boolean isCompatibleSignature(Method method) {
        Class<?> returnType = method.getReturnType();
        if (!IJsonNode.class.isAssignableFrom(returnType)) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int index = 0; index < parameterTypes.length; ++index) {
            if (IJsonNode.class.isAssignableFrom(parameterTypes[index]) || index == parameterTypes.length - 1 && method.isVarArgs() && IJsonNode.class.isAssignableFrom(parameterTypes[index].getComponentType())) continue;
            return false;
        }
        return true;
    }
}

