/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.packages;

import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.operator.Internal;
import eu.stratosphere.sopremo.operator.Name;
import eu.stratosphere.sopremo.packages.DefaultNameChooser;
import eu.stratosphere.sopremo.packages.IRegistry;
import eu.stratosphere.sopremo.packages.NameChooser;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;

public abstract class AbstractRegistry<T>
extends AbstractSopremoType
implements IRegistry<T> {
    protected static final NameChooser StandardNameChooser = new DefaultNameChooser(0, 1, 2, 3);
    private final NameChooser nameChooser;

    public AbstractRegistry(NameChooser nameChooser) {
        if (nameChooser == null) {
            throw new NullPointerException();
        }
        this.nameChooser = nameChooser;
    }

    protected AbstractRegistry() {
        this(StandardNameChooser);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractRegistry other = (AbstractRegistry)obj;
        return this.nameChooser.equals(other.nameChooser);
    }

    @Override
    public T get(Name nameAnnotation) {
        return (T)this.get(this.getNameChooser().getNames(nameAnnotation)[0]);
    }

    @Override
    public NameChooser getNameChooser() {
        return this.nameChooser;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nameChooser.hashCode();
        return result;
    }

    @Override
    public void put(Name nameAnnotation, T element) {
        String[] names;
        for (String name : names = this.getNameChooser().getNames(nameAnnotation)) {
            this.put(name, element);
        }
    }

    protected String[] getNames(AccessibleObject object) {
        Name nameAnnotation = object.getAnnotation(Name.class);
        if (nameAnnotation == null) {
            if (object.getAnnotation(Internal.class) != null) {
                return new String[]{String.format("__%s", ((Member)((Object)object)).getName())};
            }
            throw new IllegalArgumentException(object + " has no name annotation");
        }
        return this.getNameChooser().getNames(nameAnnotation);
    }

    protected String[] getNames(Class<?> object) {
        Name nameAnnotation = object.getAnnotation(Name.class);
        if (nameAnnotation == null) {
            if (object.getAnnotation(Internal.class) != null) {
                return new String[]{String.format("__%s", object.getSimpleName())};
            }
            throw new IllegalArgumentException(object + " has no name annotation");
        }
        return this.getNameChooser().getNames(nameAnnotation);
    }
}

