/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.operator;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.io.Sink;
import eu.stratosphere.sopremo.operator.ElementarySopremoModule;
import eu.stratosphere.sopremo.operator.Operator;
import eu.stratosphere.sopremo.operator.PlanWithSopremoPostPass;
import eu.stratosphere.sopremo.operator.SopremoModule;
import eu.stratosphere.sopremo.packages.ITypeRegistry;
import eu.stratosphere.sopremo.serialization.SopremoRecordLayout;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class SopremoPlan
extends AbstractSopremoType
implements Serializable {
    private static final long serialVersionUID = 5702832506916907827L;
    private final SopremoModule module;
    private EvaluationContext context = new EvaluationContext();
    private List<String> requiredPackages = new ArrayList<String>();
    private SopremoRecordLayout layout;

    public SopremoPlan() {
        this.module = new SopremoModule(0, 0);
    }

    public void addRequiredPackage(String packageName) {
        this.requiredPackages.add(packageName);
    }

    public void appendAsString(Appendable appendable) throws IOException {
        this.module.appendAsString(appendable);
    }

    public Plan asPactPlan() {
        Collection<GenericDataSink> sinks = this.checkForSinks(this.assemblePact());
        return new PlanWithSopremoPostPass(this.layout, sinks);
    }

    public Collection<eu.stratosphere.api.common.operators.Operator> assemblePact() {
        ElementarySopremoModule elementaryModule = this.module.asElementary();
        this.layout = SopremoRecordLayout.create(elementaryModule.getSchema().getKeyExpressions());
        return elementaryModule.assemblePact(this.context, this.layout);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SopremoPlan other = (SopremoPlan)obj;
        return this.module.equals(other.module);
    }

    public EvaluationContext getCompilationContext() {
        return this.context;
    }

    public Iterable<? extends Operator<?>> getContainedOperators() {
        return this.module.getReachableNodes();
    }

    public SopremoRecordLayout getLayout() {
        return this.layout;
    }

    public List<String> getRequiredPackages() {
        return this.requiredPackages;
    }

    public List<Sink> getSinks() {
        return this.module.getInternalOutputNodes();
    }

    public ITypeRegistry getTypeRegistry() {
        return this.context.getTypeRegistry();
    }

    public List<Operator<?>> getUnmatchingOperators(SopremoPlan other) {
        return this.module.getUnmatchingNodes(other.module);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.module.hashCode();
        return result;
    }

    public void setContext(EvaluationContext context) {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        this.context = context;
    }

    public void setRequiredPackages(List<String> packageNames) {
        if (packageNames == null) {
            throw new NullPointerException("requiredPackages must not be null");
        }
        this.requiredPackages = packageNames;
    }

    public void setSinks(List<Sink> sinks) {
        for (Sink sink : sinks) {
            this.module.addInternalOutput(sink);
        }
    }

    public void setSinks(Sink ... sinks) {
        this.setSinks(Arrays.asList(sinks));
    }

    private Collection<GenericDataSink> checkForSinks(Collection<eu.stratosphere.api.common.operators.Operator> contracts) {
        for (eu.stratosphere.api.common.operators.Operator contract : contracts) {
            if (GenericDataSink.class.isInstance(contract)) continue;
            throw new IllegalStateException("Operator without connected sink detected " + contract);
        }
        return contracts;
    }
}

