/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.operator;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.ISopremoType;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.operator.ConfigurableSopremoType;
import eu.stratosphere.sopremo.operator.DegreeOfParallelism;
import eu.stratosphere.sopremo.operator.ElementarySopremoModule;
import eu.stratosphere.sopremo.operator.InputCardinality;
import eu.stratosphere.sopremo.operator.JsonStream;
import eu.stratosphere.sopremo.operator.Name;
import eu.stratosphere.sopremo.operator.OutputCardinality;
import eu.stratosphere.sopremo.operator.Property;
import eu.stratosphere.util.CollectionUtil;
import eu.stratosphere.util.reflect.ReflectUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javolution.text.TypeFormat;

public abstract class Operator<Self extends Operator<Self>>
extends ConfigurableSopremoType
implements ISopremoType,
JsonStream,
Cloneable {
    public static final List<? extends EvaluationExpression> ALL_KEYS = Collections.singletonList(EvaluationExpression.VALUE);
    public static final int STANDARD_DEGREE_OF_PARALLELISM = -1;
    private final List<JsonStream> inputs = new ArrayList<JsonStream>();
    private String name;
    private List<JsonStream> outputs = new ArrayList<JsonStream>();
    private int minInputs;
    private int maxInputs;
    private int minOutputs;
    private int maxOutputs;
    private int degreeOfParallelism = -1;
    private final boolean fixedDegreeOfParallelism;

    public Operator() {
        InputCardinality inputs = (InputCardinality)ReflectUtil.getAnnotation(this.getClass(), InputCardinality.class);
        if (inputs == null) {
            throw new IllegalStateException("No InputCardinality annotation found @ " + this.getClass());
        }
        OutputCardinality outputs = (OutputCardinality)ReflectUtil.getAnnotation(this.getClass(), OutputCardinality.class);
        if (outputs == null) {
            throw new IllegalStateException("No OutputCardinality annotation found @ " + this.getClass());
        }
        this.setNumberOfInputs(inputs.value() != -1 ? inputs.value() : inputs.min(), inputs.value() != -1 ? inputs.value() : inputs.max());
        this.setNumberOfOutputs(outputs.value() != -1 ? outputs.value() : outputs.min(), outputs.value() != -1 ? outputs.value() : outputs.max());
        DegreeOfParallelism degreeOfParallelism = (DegreeOfParallelism)ReflectUtil.getAnnotation(this.getClass(), DegreeOfParallelism.class);
        if (degreeOfParallelism == null) {
            this.fixedDegreeOfParallelism = false;
        } else {
            this.fixedDegreeOfParallelism = true;
            this.degreeOfParallelism = degreeOfParallelism.value();
        }
    }

    public Operator(int minInputs, int maxInputs, int minOutputs, int maxOutputs) {
        this.setNumberOfInputs(minInputs, maxInputs);
        this.setNumberOfOutputs(minOutputs, maxOutputs);
        DegreeOfParallelism degreeOfParallelism = (DegreeOfParallelism)ReflectUtil.getAnnotation(this.getClass(), DegreeOfParallelism.class);
        if (degreeOfParallelism == null) {
            this.fixedDegreeOfParallelism = false;
        } else {
            this.fixedDegreeOfParallelism = true;
            this.degreeOfParallelism = degreeOfParallelism.value();
        }
    }

    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append(this.getName());
    }

    public abstract ElementarySopremoModule asElementaryOperators();

    @Override
    public Operator<Self> clone() {
        return (Operator)super.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operator other = (Operator)obj;
        return this.degreeOfParallelism == other.degreeOfParallelism;
    }

    public int getDegreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    public JsonStream getInput(int index) {
        return this.inputs.get(index);
    }

    public List<Operator<?>> getInputOperators() {
        return new AbstractList<Operator<?>>(){

            @Override
            public Operator<?> get(int index) {
                return Operator.this.inputs.get(index) == null ? null : ((JsonStream)Operator.this.inputs.get(index)).getSource().getOperator();
            }

            @Override
            public int indexOf(Object o) {
                ListIterator e = Operator.this.inputs.listIterator();
                while (e.hasNext()) {
                    if (o != e.next()) continue;
                    return e.previousIndex();
                }
                return -1;
            }

            @Override
            public int size() {
                return Operator.this.inputs.size();
            }
        };
    }

    public List<JsonStream> getInputs() {
        return new ArrayList<JsonStream>(this.inputs);
    }

    public int getMaxInputs() {
        return this.maxInputs;
    }

    public int getMaxOutputs() {
        return this.maxOutputs;
    }

    public int getMinInputs() {
        return this.minInputs;
    }

    public int getMinOutputs() {
        return this.minOutputs;
    }

    public String getName() {
        if (this.name == null) {
            return this.getDefaultName();
        }
        return this.name;
    }

    public int getNumInputs() {
        int numInputs;
        for (int index = numInputs = this.getMinInputs(); index < this.getMaxInputs() && index < this.inputs.size(); ++index) {
            if (this.inputs.get(index) == null) continue;
            ++numInputs;
        }
        return numInputs;
    }

    public int getNumOutputs() {
        int numOutputs;
        for (int index = numOutputs = this.getMinOutputs(); index < this.getMaxOutputs() && index < this.outputs.size(); ++index) {
            if (this.outputs.get(index) == null) continue;
            ++numOutputs;
        }
        return numOutputs;
    }

    public JsonStream getOutput(int index) {
        this.checkSize(index, this.maxOutputs, this.outputs);
        JsonStream output = this.outputs.get(index);
        if (output == null) {
            output = new Output(this, index);
            this.outputs.set(index, output);
        }
        return output;
    }

    public List<JsonStream> getOutputs() {
        ArrayList<JsonStream> outputs = new ArrayList<JsonStream>(this.minInputs);
        for (int index = 0; index < this.outputs.size(); ++index) {
            outputs.add(this.getOutput(index));
        }
        return outputs;
    }

    @Override
    public Output getSource() {
        return (Output)this.getOutput(0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.degreeOfParallelism;
        return result;
    }

    @Property
    @Name(adjective={"parallel"})
    public void setDegreeOfParallelism(int degree) {
        if (this.degreeOfParallelism == degree) {
            return;
        }
        if (degree < 1) {
            throw new RuntimeException("Degree of Parallelism cannot be set below 1");
        }
        if (this.fixedDegreeOfParallelism) {
            throw new RuntimeException("This operator has a fixed degree of parallelism of " + this.degreeOfParallelism);
        }
        this.degreeOfParallelism = degree;
    }

    public void setInput(int index, JsonStream input) {
        this.checkSize(index, this.maxInputs, this.inputs);
        this.checkInput(input);
        this.inputs.set(index, input == null ? null : input.getSource());
    }

    public void setInputs(JsonStream ... inputs) {
        this.setInputs(Arrays.asList(inputs));
    }

    public void setInputs(List<? extends JsonStream> inputs) {
        if (inputs == null) {
            throw new NullPointerException("inputs must not be null");
        }
        if (this.minInputs > inputs.size() || inputs.size() > this.maxInputs) {
            throw new IndexOutOfBoundsException();
        }
        this.inputs.clear();
        for (JsonStream jsonStream : inputs) {
            this.checkInput(jsonStream);
            this.inputs.add(jsonStream == null ? null : jsonStream.getSource());
        }
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        this.name = name;
    }

    public void validate() throws IllegalStateException {
        for (int index = 0; index < this.inputs.size(); ++index) {
            if (this.inputs.get(index) != null) continue;
            throw new IllegalStateException("unconnected input " + index);
        }
    }

    public Self withInputs(JsonStream ... inputs) {
        this.setInputs(inputs);
        return this.self();
    }

    public Self withInputs(List<? extends JsonStream> inputs) {
        this.setInputs(inputs);
        return this.self();
    }

    public Self withName(String name) {
        this.setName(name);
        return this.self();
    }

    protected void checkInput(JsonStream input) {
        if (input != null && input.getSource().getOperator() == this) {
            throw new IllegalArgumentException("Cyclic reference");
        }
    }

    protected void checkOutput(JsonStream input) {
        if (input != null && input.getSource().getOperator() == this) {
            throw new IllegalArgumentException("Cyclic reference");
        }
    }

    protected String getDefaultName() {
        return this.getClass().getSimpleName();
    }

    protected int getSafeInputIndex(JsonStream input) {
        int index = this.inputs.indexOf(input);
        if (index == -1) {
            throw new IllegalStateException("unknown input " + input);
        }
        return index;
    }

    protected final Self self() {
        return (Self)this;
    }

    protected void setNumberOfInputs(int num) {
        this.setNumberOfInputs(num, num);
    }

    protected void setNumberOfInputs(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        if (min < 0 || max < 0) {
            throw new IllegalArgumentException();
        }
        this.minInputs = min;
        this.maxInputs = max;
        CollectionUtil.ensureSize(this.inputs, (int)this.minInputs);
    }

    protected final void setNumberOfOutputs(int numberOfOutputs) {
        if (numberOfOutputs < this.outputs.size()) {
            this.outputs.subList(numberOfOutputs, this.outputs.size()).clear();
        } else {
            for (int index = this.outputs.size(); index < numberOfOutputs; ++index) {
                this.outputs.add(new Output(this, index));
            }
        }
    }

    protected void setNumberOfOutputs(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        if (min < 0 || max < 0) {
            throw new IllegalArgumentException();
        }
        this.minOutputs = min;
        this.maxOutputs = max;
        CollectionUtil.ensureSize(this.outputs, (int)this.minOutputs);
    }

    protected void setOutput(int index, JsonStream output) {
        this.checkSize(index, this.maxOutputs, this.outputs);
        this.checkOutput(output);
        this.outputs.set(index, output == null ? null : output.getSource());
    }

    protected void setOutputs(JsonStream ... outputs) {
        this.setOutputs(Arrays.asList(outputs));
    }

    protected void setOutputs(List<? extends JsonStream> outputs) {
        if (outputs == null) {
            throw new NullPointerException("outputs must not be null");
        }
        if (this.minOutputs > outputs.size() || outputs.size() > this.maxOutputs) {
            throw new IndexOutOfBoundsException();
        }
        this.outputs.clear();
        for (JsonStream jsonStream : outputs) {
            this.checkOutput(jsonStream);
            this.outputs.add(jsonStream == null ? null : jsonStream.getSource());
        }
    }

    private void checkSize(int index, int max, List<?> list) {
        if (index >= max) {
            throw new IndexOutOfBoundsException(String.format("index %s >= max %s", index, max));
        }
        CollectionUtil.ensureSize(list, (int)(index + 1));
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.outputs = new ArrayList<JsonStream>();
        CollectionUtil.ensureSize(this.outputs, (int)this.minOutputs);
    }

    public static class Output
    extends AbstractSopremoType
    implements JsonStream {
        private final int index;
        private final Operator<?> operator;

        Output() {
            this.operator = null;
            this.index = 0;
        }

        private Output(Operator<?> operator, int index) {
            this.operator = operator;
            this.index = index;
        }

        public void appendAsString(Appendable appendable) throws IOException {
            appendable.append(this.getOperator().toString()).append('@');
            TypeFormat.format((int)this.index, (Appendable)appendable);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Output other = (Output)obj;
            return this.index == other.index && this.getOperator() == other.getOperator();
        }

        public int getIndex() {
            return this.index;
        }

        public Operator<?> getOperator() {
            return this.operator;
        }

        @Override
        public Output getSource() {
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            result = 31 * result + this.getOperator().hashCode();
            return result;
        }
    }

    public static class OperatorSerializer
    extends Serializer<Operator<?>> {
        private final FieldSerializer<Operator<?>> fieldSerializer;
        private static final ThreadLocal<OperatorSerializationPool> OperatorSerializationStack = new ThreadLocal<OperatorSerializationPool>(){

            @Override
            protected OperatorSerializationPool initialValue() {
                return new OperatorSerializationPool();
            }
        };

        public OperatorSerializer(Kryo kryo, Class<Operator<?>> type) {
            this.fieldSerializer = new FieldSerializer(kryo, type);
        }

        public Operator<?> copy(Kryo kryo, Operator<?> original) {
            return (Operator)this.fieldSerializer.copy(kryo, original);
        }

        public Operator<?> read(Kryo kryo, Input input, Class<Operator<?>> type) {
            OperatorSerializationPool stack = OperatorSerializationStack.get();
            List operatorDeserializedAt = stack.operatorDeserializedId;
            if (input.readBoolean()) {
                return (Operator)operatorDeserializedAt.get(input.readByteUnsigned());
            }
            stack.stackDepth++;
            Operator object = (Operator)kryo.newInstance(type);
            operatorDeserializedAt.add(object);
            FieldSerializer.CachedField[] fields = this.fieldSerializer.getFields();
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                fields[i].read(input, (Object)object);
            }
            if (--stack.stackDepth == 0) {
                operatorDeserializedAt.clear();
            }
            return object;
        }

        public void write(Kryo kryo, com.esotericsoftware.kryo.io.Output output, Operator<?> object) {
            OperatorSerializationPool stack = OperatorSerializationStack.get();
            Map operatorSerializationId = stack.operatorSerializedId;
            Integer serializationId = (Integer)operatorSerializationId.get(object);
            output.writeBoolean(serializationId != null);
            if (serializationId != null) {
                output.writeByte(serializationId.intValue());
            } else {
                operatorSerializationId.put(object, operatorSerializationId.size());
                stack.stackDepth++;
                this.fieldSerializer.write(kryo, output, object);
                if (--stack.stackDepth == 0) {
                    operatorSerializationId.clear();
                }
            }
        }

        private static class OperatorSerializationPool {
            private final Map<Operator<?>, Integer> operatorSerializedId = new IdentityHashMap();
            private final List<Operator<?>> operatorDeserializedId = new ArrayList();
            private int stackDepth;

            private OperatorSerializationPool() {
            }
        }
    }

    public static class OperatorOutputSerializer
    extends Serializer<Output> {
        public Output copy(Kryo kryo, Output original) {
            return (Output)((Operator)kryo.copy(original.getOperator())).getOutput(original.getIndex());
        }

        public Output read(Kryo kryo, Input input, Class<Output> type) {
            Operator operator = (Operator)kryo.readClassAndObject(input);
            int index = input.readInt(true);
            System.out.println(operator + " " + index);
            return (Output)operator.getOutput(index);
        }

        public void write(Kryo kryo, com.esotericsoftware.kryo.io.Output output, Output object) {
            kryo.writeClassAndObject(output, object.getOperator());
            System.out.println(object.getOperator() + " " + object.getIndex());
            output.writeInt(object.getIndex(), true);
        }
    }
}

