/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.operator;

import com.google.common.collect.Lists;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.operator.CompositeOperator;
import eu.stratosphere.sopremo.operator.IterativeSopremoModule;
import eu.stratosphere.sopremo.operator.OutputCardinality;
import eu.stratosphere.sopremo.operator.SopremoModule;
import java.util.ArrayList;
import java.util.List;

@OutputCardinality(value=1)
public abstract class IterativeOperator<Self extends IterativeOperator<Self>>
extends CompositeOperator<Self> {
    private List<? extends EvaluationExpression> solutionSetKeyExpressions = new ArrayList<EvaluationExpression>();
    private int maximumNumberOfIterations = 1;

    public abstract void addImplementation(IterativeSopremoModule var1);

    @Override
    public void addImplementation(SopremoModule module) {
        IterativeSopremoModule iterativeModule = new IterativeSopremoModule(module.getNumInputs(), module.getNumOutputs());
        this.addImplementation(iterativeModule);
        iterativeModule.setSolutionSetKeyExpressions(this.solutionSetKeyExpressions);
        iterativeModule.setMaxNumberOfIterations(this.maximumNumberOfIterations);
        iterativeModule.embedInto(module);
    }

    public int getMaximumNumberOfIterations() {
        return this.maximumNumberOfIterations;
    }

    public void setMaximumNumberOfIterations(int maximumNumberOfIterations) {
        if (maximumNumberOfIterations < 1) {
            throw new NullPointerException("maximumNumberOfIterations must be > 0");
        }
        this.maximumNumberOfIterations = maximumNumberOfIterations;
    }

    protected List<? extends EvaluationExpression> getSolutionSetKeyExpressions() {
        return this.solutionSetKeyExpressions;
    }

    protected void setSolutionSetKeyExpressions(EvaluationExpression ... solutionSetKeyExpressions) {
        if (solutionSetKeyExpressions == null) {
            throw new NullPointerException("solutionSetKeyExpressions must not be null");
        }
        this.solutionSetKeyExpressions = Lists.newArrayList((Object[])solutionSetKeyExpressions);
    }

    protected void setSolutionSetKeyExpressions(List<? extends EvaluationExpression> solutionSetKeyExpressions) {
        if (solutionSetKeyExpressions == null) {
            throw new NullPointerException("solutionSetKeyExpressions must not be null");
        }
        this.solutionSetKeyExpressions = solutionSetKeyExpressions;
    }
}

